package com.biz.crm.sfa.business.travel.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.sfa.business.travel.local.entity.TravelApplyEntity;
import com.biz.crm.sfa.business.travel.local.model.TravelApplyConditionModel;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 出差申请表的mybatis-plus接口类 {@link TravelApplyEntity}
 *
 * @author ning.zhang
 * @date 2022-05-31 15:20:31
 */
public interface TravelApplyMapper extends BaseMapper<TravelApplyEntity> {

  /**
   * 通过ID集合查询出差申请信息
   *
   * @param ids ID集合
   * @return 出差申请信息
   */
  List<TravelApplyEntity> findByIds(@Param("ids") List<String> ids);

  /**
   * 多条件查询出差申请列表
   *
   * @param model 条件model
   * @return 出差申请列表
   */
  List<TravelApplyEntity> findByTravelApplyConditionModel(@Param("model") TravelApplyConditionModel model);
}

