package com.biz.crm.sfa.business.travel.local.observer;

import com.biz.crm.sfa.business.travel.local.entity.TravelApplyEntity;
import com.biz.crm.sfa.business.travel.local.repository.TravelApplyRepository;
import com.biz.crm.sfa.business.travel.sdk.constant.TravelConstant;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;


/**
 * 出差审批回调类
 *
 * @author ning.zhang
 * @date 2022/6/2
 */
@Component
public class TravelApplyCallbackListener implements ProcessCompleteListener {

  @Autowired
  private TravelApplyRepository travelApplyRepository;

  @Override
  public String getBusinessCode() {
    return TravelConstant.TRAVEL_APPLY_PROCESS_FORM_TYPE;
  }

  @Override
  @Transactional
  public void onProcessComplete(ProcessStatusDto dto) {
    if (!dto.getBusinessCode().equals(TravelConstant.TRAVEL_APPLY_PROCESS_FORM_TYPE)) {
      return;
    }
    TravelApplyEntity applyEntity = this.travelApplyRepository.findByApplyCode(dto.getBusinessNo(), TenantUtils.getTenantCode());
    Validate.notNull(applyEntity, "出差申请记录不存在！");
    //根据回调类别处理对应业务
    if (ProcessStatusEnum.PASS.getDictCode().equals(dto.getProcessStatus())) {
      //审批通过业务处理
      applyEntity.setAuditPassDate(LocalDateTime.now().format(TravelConstant.YYYY_MM_DD_HH_MM_SS));
      this.travelApplyRepository.updateById(applyEntity);
    }
  }
}
