package com.biz.crm.sfa.business.travel.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.travel.local.entity.TravelApplyEntity;
import com.biz.crm.sfa.business.travel.local.mapper.TravelApplyMapper;
import com.biz.crm.sfa.business.travel.local.model.TravelApplyConditionModel;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 出差申请表的数据库访问类 {@link TravelApplyEntity}
 *
 * @author ning.zhang
 * @date 2022-05-31 15:20:32
 */
@Component
public class TravelApplyRepository extends ServiceImpl<TravelApplyMapper, TravelApplyEntity> {

  /**
   * 通过ID集合查询出差申请信息
   *
   * @param ids ID集合
   * @return 出差申请信息
   */
  public List<TravelApplyEntity> findByIds(List<String> ids) {
    return this.baseMapper.findByIds(ids);
  }

  /**
   * 根据申请编码获取申请实体
   *
   * @param applyCode  申请编码
   * @param tenantCode 租户编码
   * @return 申请实体
   */
  public TravelApplyEntity findByApplyCode(String applyCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(TravelApplyEntity::getTenantCode, tenantCode)
        .eq(TravelApplyEntity::getApplyCode, applyCode)
        .one();
  }

  /**
   * 多条件查询出差申请列表
   *
   * @param model 条件model
   * @return 出差申请列表
   */
  public List<TravelApplyEntity> findByTravelApplyConditionModel(TravelApplyConditionModel model) {
    return this.baseMapper.findByTravelApplyConditionModel(model);
  }
}
