package com.biz.crm.sfa.business.travel.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.travel.local.entity.TravelApplyUserEntity;
import com.biz.crm.sfa.business.travel.local.mapper.TravelApplyUserMapper;
import org.springframework.stereotype.Component;

/**
 * 出差申请人员表的数据库访问类 {@link TravelApplyUserEntity}
 *
 * @author ning.zhang
 * @date 2022-05-31 15:20:55
 */
@Component
public class TravelApplyUserRepository extends ServiceImpl<TravelApplyUserMapper, TravelApplyUserEntity> {

  /**
   * 通过出差申请ID删除出差申请人员信息
   *
   * @param applyId 出差申请ID
   */
  public void deleteByApplyId(String applyId) {
    this.lambdaUpdate()
        .eq(TravelApplyUserEntity::getApplyId, applyId)
        .remove();
  }
}
