package com.biz.crm.sfa.business.travel.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.travel.sdk.constant.TravelConstant;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyPageDto;
import com.biz.crm.sfa.business.travel.sdk.event.TravelUpperDataListener;
import com.biz.crm.sfa.business.travel.sdk.service.TravelApplyDetailVoService;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyDetailVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @description: 出差申请明细表
 * @author: rentao
 * @date: 2022/7/5 10:14
 */
@Service
@Slf4j
public class TravelApplyDetailVoServiceImpl implements TravelApplyDetailVoService {

  @Autowired
  private UserFeignVoService userFeignVoService;
  @Autowired
  private UserVoService userVoService;
  @Autowired
  private ProcessBusinessMappingService processBusinessMappingService;
  @Autowired(required = false)
  private TravelUpperDataListener travelUpperDataListener;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<TravelApplyDetailVo> findByConditions(Pageable pageable, TravelApplyPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new TravelApplyPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    if (StringUtils.isNotBlank(dto.getUserRealName())) {
      UserConditionDto userConditionDto = new UserConditionDto();
      userConditionDto.setFullName(dto.getUserRealName());
      dto.setUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
    }
    if (Objects.isNull(this.travelUpperDataListener)) {
      return new Page<>(pageable.getPageNumber(), pageable.getPageSize(), 0);
    }
    dto.setBusinessCode(TravelConstant.TRAVEL_APPLY_PROCESS_FORM_TYPE);
    Page<TravelApplyDetailVo> entityPage = this.travelUpperDataListener.findDetailByConditions(pageable, dto);
    if (CollectionUtils.isEmpty(entityPage.getRecords())) {
      return entityPage;
    }
    this.buildProcessInfo(entityPage.getRecords());
    this.perfectUserInfo(entityPage.getRecords());
    return entityPage;
  }

  /**
   * 封装流程信息
   *
   * @param voList 待封装数据
   */
  private void buildProcessInfo(List<TravelApplyDetailVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    //解析审批记录
    List<String> applyCodes = voList.stream().map(TravelApplyDetailVo::getApplyCode).collect(Collectors.toList());
    ProcessBusinessMappingDto businessMappingDto = new ProcessBusinessMappingDto();
    businessMappingDto.setBusinessNos(applyCodes);
    businessMappingDto.setBusinessCode(TravelConstant.TRAVEL_APPLY_PROCESS_FORM_TYPE);
    List<ProcessBusinessMappingVo> businessMappingVos = this.processBusinessMappingService.findMultiByByConditions(businessMappingDto);
    Map<String, ProcessBusinessVo> processMap = CollectionUtils.isEmpty(businessMappingVos) ? Maps.newHashMap() : businessMappingVos.stream()
        .collect(Collectors.toMap(ProcessBusinessMappingVo::getBusinessNo
            , t -> this.nebulaToolkitService.copyObjectByBlankList(t, ProcessBusinessVo.class, HashSet.class, ArrayList.class)
            , (a, b) -> b));
    //转换数据
    voList.forEach(vo -> vo.setProcessBusiness(processMap.get(vo.getApplyCode())));
  }

  /**
   * 完善出差申请用户信息
   *
   * @param list 出差申请
   */
  private void perfectUserInfo(List<TravelApplyDetailVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    Set<String> userNames = list.stream().flatMap(applyVo -> {
      Set<String> userList = Sets.newHashSet();
      userList.add(applyVo.getUserName());
      userList.add(applyVo.getTravelUserName());
      return userList.stream();
    }).collect(Collectors.toSet());
    List<UserVo> userVoList = this.userFeignVoService.findByUserNames(Lists.newArrayList(userNames));
    if (CollectionUtils.isEmpty(userVoList)) {
      return;
    }
    Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
    list.forEach(vo -> {
      UserVo userVo = userMap.getOrDefault(vo.getUserName(), new UserVo());
      vo.setUserRealName(userVo.getFullName());
      UserVo user = userMap.getOrDefault(vo.getTravelUserName(), new UserVo());
      vo.setTravelFullName(user.getFullName());
    });
  }
}
