package com.biz.crm.sfa.business.travel.local.service.internal;

import com.biz.crm.sfa.business.travel.local.entity.TravelApplyUserEntity;
import com.biz.crm.sfa.business.travel.local.repository.TravelApplyUserRepository;
import com.biz.crm.sfa.business.travel.local.service.TravelApplyUserService;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 出差申请人员表服务实现类
 *
 * @author ning.zhang
 * @date 2022-05-31 15:20:55
 */
@Slf4j
@Service("travelApplyUserService")
public class TravelApplyUserServiceImpl implements TravelApplyUserService {

  @Autowired
  private TravelApplyUserRepository travelApplyUserRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void update(TravelApplyDto dto) {
    this.updateValidation(dto);
    this.travelApplyUserRepository.deleteByApplyId(dto.getId());
    List<TravelApplyUserEntity> entities = dto.getTravelUserList().stream().map(pictureDto -> {
      TravelApplyUserEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(pictureDto, TravelApplyUserEntity.class, HashSet.class, ArrayList.class);
      entity.setApplyId(dto.getId());
      entity.setTenantCode(dto.getTenantCode());
      return entity;
    }).collect(Collectors.toList());
    this.travelApplyUserRepository.saveBatch(entities);
  }

  /**
   * 在修改travelApplyUser模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param dto 检查对象
   */
  private void updateValidation(TravelApplyDto dto) {
    Validate.notBlank(dto.getId(), "出差申请ID不能为空");
    dto.getTravelUserList().forEach(pictureDto -> {
      Validate.notBlank(pictureDto.getUserName(), "缺失出差人员账号");
    });
  }
}
