package com.biz.crm.sfa.business.travel.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.travel.local.entity.TravelApplyEntity;
import com.biz.crm.sfa.business.travel.local.model.TravelApplyConditionModel;
import com.biz.crm.sfa.business.travel.local.repository.TravelApplyRepository;
import com.biz.crm.sfa.business.travel.sdk.constant.TravelConstant;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyPageDto;
import com.biz.crm.sfa.business.travel.sdk.event.TravelUpperDataListener;
import com.biz.crm.sfa.business.travel.sdk.service.TravelApplyVoService;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyUserVo;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 出差申请Vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/5/31
 */
@Slf4j
@Service
public class TravelApplyVoServiceImpl implements TravelApplyVoService {

  @Autowired
  private TravelApplyRepository travelApplyRepository;
  @Autowired
  private UserFeignVoService userFeignVoService;
  @Autowired
  private PositionVoService positionVoService;
  @Autowired
  private UserInfoVoService userInfoVoService;
  @Autowired
  private UserVoService userVoService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private ProcessBusinessMappingService processBusinessMappingService;
  @Autowired(required = false)
  private TravelUpperDataListener travelUpperDataListener;

  @Override
  public List<TravelApplyVo> findByIds(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return Lists.newLinkedList();
    }
    List<TravelApplyEntity> entities = this.travelApplyRepository.findByIds(ids);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();
    }
    List<TravelApplyVo> list = (List<TravelApplyVo>) this.nebulaToolkitService.copyCollectionByBlankList(entities, TravelApplyEntity.class
        , TravelApplyVo.class, HashSet.class, ArrayList.class);
    this.buildProcessInfo(list);
    this.perfectUserInfo(list);
    return list;
  }

  @Override
  public List<TravelApplyVo> findByApplyCodes(List<String> applyCodes) {
    if (CollectionUtils.isEmpty(applyCodes)) {
      return Lists.newLinkedList();
    }
    TravelApplyConditionModel model = new TravelApplyConditionModel();
    model.setTenantCode(TenantUtils.getTenantCode());
    model.setApplyCodes(applyCodes);
    List<TravelApplyEntity> entities = this.travelApplyRepository.findByTravelApplyConditionModel(model);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();
    }
    List<TravelApplyVo> list = (List<TravelApplyVo>) this.nebulaToolkitService.copyCollectionByBlankList(entities, TravelApplyEntity.class
        , TravelApplyVo.class, HashSet.class, ArrayList.class);
    this.buildProcessInfo(list);
    this.perfectUserInfo(list);
    return list;
  }

  @Override
  public Page<TravelApplyVo> findByConditions(Pageable pageable, TravelApplyPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new TravelApplyPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    dto.setUserNames(Sets.newHashSet(loginDetails.getAccount()));
    List<PositionVo> positionList = this.positionVoService.findByParentCode(loginDetails.getPostCode());
    if (!CollectionUtils.isEmpty(positionList)) {
      List<UserInfoVo> userList = this.userInfoVoService.findByPositionCodes(positionList.stream().map(PositionVo::getPositionCode).collect(Collectors.toSet()));
      if (!CollectionUtils.isEmpty(userList)) {
        dto.getUserNames().addAll(userList.stream().map(UserInfoVo::getUserName).collect(Collectors.toList()));
      }
    }
    //如果搜索了关键字,需要查询关键字对应的用户集合
    if (StringUtils.isNotBlank(dto.getKeyWord())) {
      UserConditionDto userConditionDto = new UserConditionDto();
      userConditionDto.setFullName(dto.getKeyWord());
      dto.setKeyWordUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
    }
    if (StringUtils.isNotEmpty(dto.getApplyDateStart())) {
      dto.setApplyDateStart(String.format("%s %s", dto.getApplyDateStart(), TravelConstant.TIME_STR_000000));
    }
    if (StringUtils.isNotEmpty(dto.getApplyDateEnd())) {
      dto.setApplyDateEnd(String.format("%s %s", dto.getApplyDateEnd(), TravelConstant.TIME_STR_235959));
    }
    if (Objects.isNull(this.travelUpperDataListener)) {
      return new Page<>(pageable.getPageNumber(), pageable.getPageSize(), 0);
    }
    dto.setBusinessCode(TravelConstant.TRAVEL_APPLY_PROCESS_FORM_TYPE);
    Page<TravelApplyVo> entityPage = this.travelUpperDataListener.findByConditions(pageable, dto);
    if (CollectionUtils.isEmpty(entityPage.getRecords())) {
      return entityPage;
    }
    this.buildProcessInfo(entityPage.getRecords());
    this.perfectUserInfo(entityPage.getRecords());
    return entityPage;
  }

  /**
   * 封装流程信息
   *
   * @param voList 待封装数据
   */
  private void buildProcessInfo(List<TravelApplyVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    //解析审批记录
    List<String> applyCodes = voList.stream().map(TravelApplyVo::getApplyCode).collect(Collectors.toList());
    ProcessBusinessMappingDto businessMappingDto = new ProcessBusinessMappingDto();
    businessMappingDto.setBusinessCode(TravelConstant.TRAVEL_APPLY_PROCESS_FORM_TYPE);
    businessMappingDto.setBusinessNos(applyCodes);
    List<ProcessBusinessMappingVo> businessMappingVos = this.processBusinessMappingService.findMultiByByConditions(businessMappingDto);
    Map<String, ProcessBusinessVo> processMap = CollectionUtils.isEmpty(businessMappingVos) ? Maps.newHashMap() : businessMappingVos.stream()
        .collect(Collectors.toMap(ProcessBusinessMappingVo::getBusinessNo
            , t -> this.nebulaToolkitService.copyObjectByBlankList(t, ProcessBusinessVo.class, HashSet.class, ArrayList.class)
            , (a, b) -> b));
    //转换数据
    voList.forEach(vo -> vo.setProcessBusiness(processMap.get(vo.getApplyCode())));
  }

  /**
   * 完善出差申请用户信息
   *
   * @param list 出差申请
   */
  private void perfectUserInfo(List<TravelApplyVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    Set<String> userNames = list.stream().flatMap(applyVo -> {
      Set<String> userList = Sets.newHashSet();
      userList.add(applyVo.getUserName());
      if (!CollectionUtils.isEmpty(applyVo.getTravelUserList())) {
        userList.addAll(applyVo.getTravelUserList().stream().map(TravelApplyUserVo::getUserName).collect(Collectors.toSet()));
      }
      return userList.stream();
    }).collect(Collectors.toSet());
    List<UserVo> userVoList = this.userFeignVoService.findByUserNames(Lists.newArrayList(userNames));
    if (CollectionUtils.isEmpty(userVoList)) {
      return;
    }
    Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
    list.forEach(vo -> {
      UserVo userVo = userMap.getOrDefault(vo.getUserName(), new UserVo());
      vo.setPositionCode(userVo.getPositionCode());
      vo.setPositionName(userVo.getPositionName());
      vo.setOrgCode(userVo.getOrgCode());
      vo.setOrgName(userVo.getOrgName());
      vo.setUserRealName(userVo.getFullName());
      if (!CollectionUtils.isEmpty(vo.getTravelUserList())) {
        vo.getTravelUserList().forEach(travelApplyUserVo -> {
          UserVo applyUserVo = userMap.getOrDefault(travelApplyUserVo.getUserName(), new UserVo());
          travelApplyUserVo.setUserRealName(applyUserVo.getFullName());
        });
      }
    });
  }
}
