/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.travel.local.observer;

import com.biz.crm.sfa.business.travel.local.entity.TravelApplyEntity;
import com.biz.crm.sfa.business.travel.local.repository.TravelApplyRepository;
import com.biz.crm.sfa.business.travel.sdk.constant.TravelConstant;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.time.LocalDateTime;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TravelApplyCallbackListener
implements ProcessCompleteListener {
    @Autowired
    private TravelApplyRepository travelApplyRepository;

    public String getBusinessCode() {
        return "travel_apply";
    }

    @Transactional
    public void onProcessComplete(ProcessStatusDto dto) {
        if (!dto.getBusinessCode().equals("travel_apply")) {
            return;
        }
        TravelApplyEntity applyEntity = this.travelApplyRepository.findByApplyCode(dto.getBusinessNo(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)applyEntity), (String)"\u51fa\u5dee\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        if (ProcessStatusEnum.PASS.getDictCode().equals(dto.getProcessStatus())) {
            applyEntity.setAuditPassDate(LocalDateTime.now().format(TravelConstant.YYYY_MM_DD_HH_MM_SS));
            this.travelApplyRepository.updateById((Object)applyEntity);
        }
    }
}

