/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.travel.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.travel.local.entity.TravelApplyEntity;
import com.biz.crm.sfa.business.travel.local.model.TravelApplyConditionModel;
import com.biz.crm.sfa.business.travel.local.repository.TravelApplyRepository;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyPageDto;
import com.biz.crm.sfa.business.travel.sdk.event.TravelUpperDataListener;
import com.biz.crm.sfa.business.travel.sdk.service.TravelApplyVoService;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyUserVo;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TravelApplyVoServiceImpl
implements TravelApplyVoService {
    private static final Logger log = LoggerFactory.getLogger(TravelApplyVoServiceImpl.class);
    @Autowired
    private TravelApplyRepository travelApplyRepository;
    @Autowired
    private UserFeignVoService userFeignVoService;
    @Autowired
    private PositionVoService positionVoService;
    @Autowired
    private UserInfoVoService userInfoVoService;
    @Autowired
    private UserVoService userVoService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProcessBusinessMappingService processBusinessMappingService;
    @Autowired(required=false)
    private TravelUpperDataListener travelUpperDataListener;

    public List<TravelApplyVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newLinkedList();
        }
        List<TravelApplyEntity> entities = this.travelApplyRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(entities, TravelApplyEntity.class, TravelApplyVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.buildProcessInfo(list);
        this.perfectUserInfo(list);
        return list;
    }

    public List<TravelApplyVo> findByApplyCodes(List<String> applyCodes) {
        if (CollectionUtils.isEmpty(applyCodes)) {
            return Lists.newLinkedList();
        }
        TravelApplyConditionModel model = new TravelApplyConditionModel();
        model.setTenantCode(TenantUtils.getTenantCode());
        model.setApplyCodes(applyCodes);
        List<TravelApplyEntity> entities = this.travelApplyRepository.findByTravelApplyConditionModel(model);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(entities, TravelApplyEntity.class, TravelApplyVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.buildProcessInfo(list);
        this.perfectUserInfo(list);
        return list;
    }

    public Page<TravelApplyVo> findByConditions(Pageable pageable, TravelApplyPageDto dto) {
        List userList;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (TravelApplyPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new TravelApplyPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        dto.setUserNames((Set)Sets.newHashSet((Object[])new String[]{loginDetails.getAccount()}));
        List positionList = this.positionVoService.findByParentCode(loginDetails.getPostCode());
        if (!CollectionUtils.isEmpty((Collection)positionList) && !CollectionUtils.isEmpty((Collection)(userList = this.userInfoVoService.findByPositionCodes(positionList.stream().map(PositionVo::getPositionCode).collect(Collectors.toSet()))))) {
            dto.getUserNames().addAll(userList.stream().map(UserInfoVo::getUserName).collect(Collectors.toList()));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getKeyWord())) {
            UserConditionDto userConditionDto = new UserConditionDto();
            userConditionDto.setFullName(dto.getKeyWord());
            dto.setKeyWordUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getApplyDateStart())) {
            dto.setApplyDateStart(String.format("%s %s", dto.getApplyDateStart(), "00:00:00"));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getApplyDateEnd())) {
            dto.setApplyDateEnd(String.format("%s %s", dto.getApplyDateEnd(), "23:59:59"));
        }
        if (Objects.isNull(this.travelUpperDataListener)) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize(), 0L);
        }
        dto.setBusinessCode("travel_apply");
        Page entityPage = this.travelUpperDataListener.findByConditions(pageable, dto);
        if (CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return entityPage;
        }
        this.buildProcessInfo(entityPage.getRecords());
        this.perfectUserInfo(entityPage.getRecords());
        return entityPage;
    }

    private void buildProcessInfo(List<TravelApplyVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        List applyCodes = voList.stream().map(TravelApplyVo::getApplyCode).collect(Collectors.toList());
        ProcessBusinessMappingDto businessMappingDto = new ProcessBusinessMappingDto();
        businessMappingDto.setBusinessCode("travel_apply");
        businessMappingDto.setBusinessNos(applyCodes);
        List businessMappingVos = this.processBusinessMappingService.findMultiByByConditions(businessMappingDto);
        HashMap processMap = CollectionUtils.isEmpty((Collection)businessMappingVos) ? Maps.newHashMap() : businessMappingVos.stream().collect(Collectors.toMap(ProcessBusinessMappingVo::getBusinessNo, t -> (ProcessBusinessVo)this.nebulaToolkitService.copyObjectByBlankList(t, ProcessBusinessVo.class, HashSet.class, ArrayList.class, new String[0]), (a, b) -> b));
        voList.forEach(vo -> vo.setProcessBusiness((ProcessBusinessVo)processMap.get(vo.getApplyCode())));
    }

    private void perfectUserInfo(List<TravelApplyVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Set userNames = list.stream().flatMap(applyVo -> {
            HashSet userList = Sets.newHashSet();
            userList.add(applyVo.getUserName());
            if (!CollectionUtils.isEmpty((Collection)applyVo.getTravelUserList())) {
                userList.addAll(applyVo.getTravelUserList().stream().map(TravelApplyUserVo::getUserName).collect(Collectors.toSet()));
            }
            return userList.stream();
        }).collect(Collectors.toSet());
        List userVoList = this.userFeignVoService.findByUserNames((List)Lists.newArrayList(userNames));
        if (CollectionUtils.isEmpty((Collection)userVoList)) {
            return;
        }
        Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
        list.forEach(vo -> {
            UserVo userVo = userMap.getOrDefault(vo.getUserName(), new UserVo());
            vo.setPositionCode(userVo.getPositionCode());
            vo.setPositionName(userVo.getPositionName());
            vo.setOrgCode(userVo.getOrgCode());
            vo.setOrgName(userVo.getOrgName());
            vo.setUserRealName(userVo.getFullName());
            if (!CollectionUtils.isEmpty((Collection)vo.getTravelUserList())) {
                vo.getTravelUserList().forEach(travelApplyUserVo -> {
                    UserVo applyUserVo = userMap.getOrDefault(travelApplyUserVo.getUserName(), new UserVo());
                    travelApplyUserVo.setUserRealName(applyUserVo.getFullName());
                });
            }
        });
    }
}

