package com.biz.crm.sfa.business.travel.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.business.common.sdk.dto.WorkflowFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 出差申请Dto
 *
 * @author ning.zhang
 * @date 2022/5/31
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "TravelApplyDto", description = "出差申请Dto")
public class TravelApplyDto extends WorkflowFlagOpDto {

  /**
   * 开始时间(yyyy-MM-dd)
   */
  @ApiModelProperty(value = "开始时间(yyyy-MM-dd)")
  private String beginTime;

  /**
   * 结束时间(yyyy-MM-dd)
   */
  @ApiModelProperty(value = "结束时间(yyyy-MM-dd)")
  private String endTime;

  /**
   * 出差地点
   */
  @ApiModelProperty("出差地点")
  private String travelAddress;

  /**
   * 出差目的 出差目的
   */
  @ApiModelProperty("出差目的")
  private String travelObjective;

  /**
   * 出差人员
   */
  @ApiModelProperty("出差人员")
  private List<TravelApplyUserDto> travelUserList;

  /**
   * 人员账号
   */
  @ApiModelProperty(value = "人员账号", hidden = true)
  private String userName;

  /**
   * 申请日期(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty(value = "申请日期(yyyy-MM-dd HH:mm:ss)", hidden = true)
  private String applyDate;

  /**
   * 申请编码
   */
  @ApiModelProperty(value = "申请编码", hidden = true)
  private String applyCode;
}
