package com.biz.crm.sfa.business.travel.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Set;

/**
 * 出差申请分页查询Dto
 *
 * @author ning.zhang
 * @date 2022/5/31
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "TravelApplyDto", description = "出差申请分页查询Dto")
public class TravelApplyPageDto extends TenantDto {

  /**
   * 人员账号集合
   */
  @ApiModelProperty(value = "人员账号集合", hidden = true)
  private Set<String> userNames;

  /**
   * 关键字对应人员账号集合
   */
  @ApiModelProperty(value = "关键字对应人员账号集合", hidden = true)
  private Set<String> keyWordUserNames;

  /**
   * 关键字
   */
  @ApiModelProperty("关键字")
  private String keyWord;

  /**
   * 申请日期开始 (yyyy-MM-dd)
   */
  @ApiModelProperty("申请日期开始 (yyyy-MM-dd)")
  private String applyDateStart;

  /**
   * 申请日期结束 (yyyy-MM-dd)
   */
  @ApiModelProperty("申请日期结束 (yyyy-MM-dd)")
  private String applyDateEnd;

  /**
   * 出差开始时间开始 (yyyy-MM-dd)
   */
  @ApiModelProperty("出差开始时间开始 (yyyy-MM-dd)")
  private String beginTimeStart;

  /**
   * 出差开始时间结束 (yyyy-MM-dd)
   */
  @ApiModelProperty("出差开始时间结束 (yyyy-MM-dd)")
  private String beginTimeEnd;

  /**
   * 出差结束时间开始 (yyyy-MM-dd)
   */
  @ApiModelProperty("出差结束时间开始 (yyyy-MM-dd)")
  private String endTimeStart;

  /**
   * 出差结束时间结束 (yyyy-MM-dd)
   */
  @ApiModelProperty("出差结束时间结束 (yyyy-MM-dd)")
  private String endTimeEnd;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  private String processStatus;

  /**
   * 申请人员账号
   */
  @ApiModelProperty(value = "申请人员账号")
  private String userName;

  /**
   * 申请人员名称
   */
  @ApiModelProperty(value = "申请人员名称")
  private String userRealName;


  @ApiModelProperty("职位编码")
  private String postCode;

  @ApiModelProperty("职位名称")
  private String postName;

  @ApiModelProperty("组织编码")
  private String orgCode;

  @ApiModelProperty("组织名称")
  private String orgName;

}
