package com.biz.crm.sfa.business.travel.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.travel.sdk.dto.TravelApplyPageDto;
import com.biz.crm.sfa.business.travel.sdk.vo.TravelApplyVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 出差申请Vo服务接口
 *
 * @author ning.zhang
 * @date 2022/5/31
 */
public interface TravelApplyVoService {

  /**
   * 通过ID集合查询出差申请信息
   *
   * @param ids ID集合
   * @return 出差申请信息
   */
  List<TravelApplyVo> findByIds(List<String> ids);

  /**
   * 出差申请分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<TravelApplyVo> 出差申请分页信息
   */
  Page<TravelApplyVo> findByConditions(Pageable pageable, TravelApplyPageDto dto);
}
