package com.biz.crm.sfa.business.travel.sdk.vo;

import com.biz.crm.business.common.sdk.vo.WorkflowFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 出差申请明细Vo
 * @author: rentao
 * @date: 2022/7/5 10:09
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "TravelApplyDetailVo", description = "出差申请明细Vo")
public class TravelApplyDetailVo extends WorkflowFlagOpVo {

  private static final long serialVersionUID = -2011870232968849103L;
  /**
   * 申请编码
   */
  @ApiModelProperty("申请编码")
  private String applyCode;

  /**
   * 申请日期(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty(value = "申请日期(yyyy-MM-dd HH:mm:ss)")
  private String applyDate;

  /**
   * 开始时间(yyyy-MM-dd)
   */
  @ApiModelProperty(value = "开始时间(yyyy-MM-dd)")
  private String beginTime;

  /**
   * 结束时间(yyyy-MM-dd)
   */
  @ApiModelProperty(value = "结束时间(yyyy-MM-dd)")
  private String endTime;

  /**
   * 申请人员账号
   */
  @ApiModelProperty(value = "申请人员账号")
  private String userName;

  /**
   * 申请人员名称
   */
  @ApiModelProperty(value = "申请人员名称")
  private String userRealName;

  /**
   * 申请人员职位编码
   */
  @ApiModelProperty(value = "申请人员职位编码")
  private String postCode;

  /**
   * 申请人员职位名称
   */
  @ApiModelProperty(value = "申请人员职位名称")
  private String postName;

  /**
   * 申请人员所属组织编码
   */
  @ApiModelProperty(value = "申请人员所属组织编码")
  private String orgCode;

  /**
   * 申请人员所属组织名称
   */
  @ApiModelProperty(value = "申请人员所属组织名称")
  private String orgName;

  /**
   * 出差地点
   */
  @ApiModelProperty(value = "出差地点")
  private String travelAddress;

  /**
   * 出差目的 出差目的
   */
  @ApiModelProperty(value = "出差目的")
  private String travelObjective;

  /**
   * 出差人账号
   */
  @ApiModelProperty(value = "出差人账号")
  private String travelUserName;

  /**
   * 出差人姓名
   */
  @ApiModelProperty(value = "出差人姓名")
  private String travelFullName;

}