package com.biz.crm.sfa.business.visit.plan.line.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 线路组和线路组拜访信息关系 实体类
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_visit_plan_line_range_mapping")
@Table(name = "sfa_visit_plan_line_range_mapping")
@ApiModel(value = "VisitPlanLineRangeMapping", description = "线路组和线路组拜访信息关系表")
@org.hibernate.annotations.Table(appliesTo = "sfa_visit_plan_line_range_mapping", comment = "线路组和线路组拜访信息关系表")
public class VisitPlanLineRangeMapping extends UuidEntity {

  private static final long serialVersionUID = -7069914838060160741L;
  /**
   * 线路组拜访信息id
   */
  @ApiModelProperty("线路组拜访信息id")
  @Column(name = "range_id", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '线路组拜访信息id'")
  private String rangeId;

  /**
   * 线路组编码
   */
  @ApiModelProperty("线路组编码")
  @Column(name = "line_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '线路组编码'")
  private String lineCode;

  /**
   * 线路组名称
   */
  @ApiModelProperty("线路组名称")
  @Column(name = "line_name", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '线路组名称'")
  private String lineName;


}
