package com.biz.crm.sfa.business.visit.plan.line.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRangeMapping;
import com.biz.crm.sfa.business.visit.plan.line.local.mapper.VisitPlanLineRangeMappingMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 线路组和线路组拜访信息关系表(VisitPlanLineRangeMapping)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
@Component
public class VisitPlanLineRangeMappingRepository extends ServiceImpl<VisitPlanLineRangeMappingMapper, VisitPlanLineRangeMapping> {

  /**
   * 根据拜访信息id删除数据
   *
   * @param rangeId
   */
  public void deleteByRangeId(String rangeId) {
    this.lambdaUpdate().eq(VisitPlanLineRangeMapping::getRangeId, rangeId).remove();
  }

  /**
   * 根据拜访信息id查询数据
   *
   * @param rangeId
   * @return
   */
  public List<VisitPlanLineRangeMapping> findByRangeId(String rangeId) {
    return this.lambdaQuery().eq(VisitPlanLineRangeMapping::getRangeId, rangeId).list();
  }

  /**
   * 根据rangeID集合查询数据
   *
   * @param rangeIds
   * @return
   */
  public List<VisitPlanLineRangeMapping> findByRangeIds(List<String> rangeIds) {
    return this.lambdaQuery().in(VisitPlanLineRangeMapping::getRangeId, rangeIds).list();
  }

  /**
   * 根据线路组编码集合查询数据
   *
   * @param lineCodes
   * @return
   */
  public List<VisitPlanLineRangeMapping> findByLineCodes(List<String> lineCodes) {
    return this.lambdaQuery().in(VisitPlanLineRangeMapping::getLineCode, lineCodes).list();
  }
}

