package com.biz.crm.sfa.business.visit.plan.line.local.service;


import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRangeMapping;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 线路组和线路组拜访信息关系表(VisitPlanLineRangeMapping)表服务接口
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
public interface VisitPlanLineRangeMappingService {

  /**
   * 新增数据（批量）
   *
   * @param visitPlanLineRangeMappingSet 实体对象集合
   * @return
   */
  void createBatch(Set<VisitPlanLineRangeMapping> visitPlanLineRangeMappingSet);

  /**
   * 根据维度范围id删除数据
   *
   * @param rangeId
   */
  void deleteByRangeId(String rangeId);

  /**
   * 根据维度范围id查询数据
   *
   * @param rangeId
   * @return
   */
  Set<VisitPlanLineRangeMapping> findByRangeId(String rangeId);

  /**
   * 根据拜访计划编码集合查询map
   * k-拜访计划编码，v-关联线路组
   *
   * @param visitPlanCodes
   * @return
   */
  Map<String, List<VisitPlanLineRangeMapping>> findByVisitPlanCodesStuMap(List<String> visitPlanCodes);
}

