package com.biz.crm.sfa.business.visit.plan.line.local.service;


import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineRouteRangeVo;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRange;

import java.util.List;

/**
 * 线路组拜访信息表(VisitPlanLineRange)表服务接口
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
public interface VisitPlanLineRangeService {

  /**
   * 新增数据
   *
   * @param visitPlanLineRange 实体对象
   * @return 新增结果
   */
  VisitPlanLineRange create(VisitPlanLineRange visitPlanLineRange);

  /**
   * 修改新据
   *
   * @param visitPlanLineRange 实体对象
   * @return 修改结果
   */
  VisitPlanLineRange update(VisitPlanLineRange visitPlanLineRange);


  /**
   * 根据拜访计划编码查询拜访信息
   *
   * @param visitPlanCode
   * @return 拜访信息
   */
  VisitPlanLineRouteRangeVo findByVisitPlanCode(String visitPlanCode);

  /**
   * 根据拜访计划编码集合查询基础信息集合
   *
   * @param visitPlanCodes
   * @return
   */
  List<VisitPlanLineRange> findByVisitPlanCodes(List<String> visitPlanCodes);
}

