package com.biz.crm.sfa.business.visit.plan.line.local.service.internal;


import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineClientInfo;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineClientInfoRepository;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineClientInfoService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 拜访计划制定表(VisitPlanLineClientInfo)表服务实现类
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
@Service("visitPlanLineClientInfoService")
public class VisitPlanLineClientInfoServiceImpl implements VisitPlanLineClientInfoService {

  @Autowired
  private VisitPlanLineClientInfoRepository visitPlanLineClientInfoRepository;


  @Transactional
  @Override
  public void deleteByLineCode(String lineCode) {
    this.visitPlanLineClientInfoRepository.deleteByLineCode(lineCode);
  }

  @Transactional
  @Override
  public void createBatch(List<VisitPlanLineClientInfo> visitPlanLineClientInfos) {
    Validate.isTrue(!CollectionUtils.isEmpty(visitPlanLineClientInfos), "新增数据时，客户信息入参集合不能为空！");
    visitPlanLineClientInfos.stream().forEach(visitPlanLineClientInfo -> this.createValidate(visitPlanLineClientInfo));
    this.visitPlanLineClientInfoRepository.saveBatch(visitPlanLineClientInfos);
  }

  @Override
  public List<VisitPlanLineClientInfo> findByLineCode(String lineCode) {
    if (StringUtils.isBlank(lineCode)) {
      return new ArrayList<>(0);
    }
    return this.visitPlanLineClientInfoRepository.findByLineCode(lineCode);
  }

  /**
   * 创建验证
   *
   * @param visitPlanLineClientInfo
   */
  private void createValidate(VisitPlanLineClientInfo visitPlanLineClientInfo) {
    Validate.notNull(visitPlanLineClientInfo, "新增时，对象信息不能为空！");
    visitPlanLineClientInfo.setId(null);
    Validate.notBlank(visitPlanLineClientInfo.getClientCode(), "新增数据时，客户编码不能为空！");
    Validate.notNull(visitPlanLineClientInfo.getClientOrder(), "新增数据时，排序不能为空！");
    Validate.isTrue(visitPlanLineClientInfo.getClientOrder().compareTo(0) > 0, "新增数据时，排序必须大于0！");
    Validate.notBlank(visitPlanLineClientInfo.getClientType(), "新增数据时，客户类型不能为空！");
    Validate.notBlank(visitPlanLineClientInfo.getLineCode(), "新增数据时，线路组编码不能为空！");
    Validate.notNull(ClientTypeEnum.getByDictCode(visitPlanLineClientInfo.getClientType()), "新增数据时，当前客户类型不存在！");
  }
}

