package com.biz.crm.sfa.business.visit.plan.line.local.service.internal;

import com.biz.crm.business.sfa.visit.plan.line.sdk.service.VisitPlanLineRangeClientInfoVoService;
import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineRangeClientInfoVo;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineRangeClientInfoVoRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 拜访计划线路组拜访客户信息service实现
 *
 * @author songjingen
 */
@Service
public class VisitPlanLineRangeClientInfoVoServiceImpl implements VisitPlanLineRangeClientInfoVoService {

  @Autowired
  private VisitPlanLineRangeClientInfoVoRepository visitPlanLineRangeClientInfoVoRepository;


  @Override
  public Map<String, List<VisitPlanLineRangeClientInfoVo>> findByRangeIds(List<String> rangeIds) {
    if (CollectionUtils.isEmpty(rangeIds)) {
      return new HashMap<>(0);
    }
    List<VisitPlanLineRangeClientInfoVo> byRangeIds = this.visitPlanLineRangeClientInfoVoRepository.findByRangeIds(rangeIds);
    if (CollectionUtils.isEmpty(byRangeIds)) {
      return new HashMap<>(0);
    }
    return byRangeIds.stream().collect(Collectors.groupingBy(VisitPlanLineRangeClientInfoVo::getRangeId));
  }
}
