package com.biz.crm.sfa.business.visit.plan.line.local.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineRouteRangeVo;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRange;
import com.biz.crm.sfa.business.visit.plan.line.local.register.VisitPlanLineRouteRegister;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineRangeService;
import com.biz.crm.sfa.business.visit.plan.sdk.abstracts.VisitPlanRouteRangeAbstract;
import com.biz.crm.sfa.business.visit.plan.sdk.constant.VisitPlanConstant;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanRouteRangeModel;
import com.biz.crm.sfa.business.visit.plan.sdk.strategy.VisitPlanRouteStrategy;
import com.bizunited.nebula.common.util.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 线路组维度观察者实现类
 *
 * @author songjingen
 */
@Component
public class VisitPlanLineRouteStrategy implements VisitPlanRouteStrategy {

  @Autowired
  private VisitPlanLineRangeService visitPlanLineRangeService;

  @Autowired
  private VisitPlanLineRouteRegister visitPlanLineRouteRegister;

  @Override
  public String getKey() {
    return this.visitPlanLineRouteRegister.getKey();
  }

  @Override
  public VisitPlanRouteRangeModel onCreate(JSONObject jsonObject) {
    JSONObject jsonLineObject = jsonObject.getJSONObject(this.getKey());
    Validate.notNull(jsonLineObject, "创建维度信息时，线路组维度拜访信息不能为空！");
    String visitPlanCode = jsonObject.getString(VisitPlanConstant.VISIT_PLAN_CODE_FLAG);
    Validate.notBlank(visitPlanCode, "创建维度信息时，拜访计划编码不能为空！");
    VisitPlanLineRange visitPlanLineRange = JsonUtils.json2Obj(jsonLineObject.toJSONString(), VisitPlanLineRange.class);
    visitPlanLineRange.setVisitPlanCode(visitPlanCode);
    this.visitPlanLineRangeService.create(visitPlanLineRange);
    return this.buildVisitPlanRouteRangeModel(visitPlanLineRange);
  }

  @Override
  public VisitPlanRouteRangeModel onUpdate(JSONObject jsonObject) {
    JSONObject jsonLineObject = jsonObject.getJSONObject(this.getKey());
    Validate.notNull(jsonLineObject, "修改维度信息时，线路组维度拜访信息不能为空！");
    String visitPlanCode = jsonObject.getString(VisitPlanConstant.VISIT_PLAN_CODE_FLAG);
    Validate.notBlank(visitPlanCode, "创建维度信息时，拜访计划编码不能为空！");
    VisitPlanLineRange visitPlanLineRange = JsonUtils.json2Obj(jsonLineObject.toJSONString(), VisitPlanLineRange.class);
    visitPlanLineRange.setVisitPlanCode(visitPlanCode);
    this.visitPlanLineRangeService.update(visitPlanLineRange);
    return this.buildVisitPlanRouteRangeModel(visitPlanLineRange);
  }

  /**
   * 根据拜访计划编码查询数据
   *
   * @param visitPlanCode 拜访计划编码
   * @return 拜访计划维度拜访信息
   */
  @Override
  public VisitPlanRouteRangeAbstract onFindRouteRange(String visitPlanCode) {
    if (StringUtils.isAnyBlank(visitPlanCode)) {
      return null;
    }
    VisitPlanLineRouteRangeVo visitPlanLineRouteRangeVo = this.visitPlanLineRangeService.findByVisitPlanCode(visitPlanCode);
    return visitPlanLineRouteRangeVo;
  }

  /**
   * 构建返回model
   *
   * @param visitPlanLineRange
   */
  private VisitPlanRouteRangeModel buildVisitPlanRouteRangeModel(VisitPlanLineRange visitPlanLineRange) {
    if (visitPlanLineRange == null) {
      return null;
    }
    VisitPlanRouteRangeModel visitPlanRouteRangeModel = new VisitPlanRouteRangeModel();
    visitPlanRouteRangeModel.setVisitPlanCode(visitPlanLineRange.getVisitPlanCode());
    visitPlanRouteRangeModel.setStartDate(visitPlanLineRange.getLoopsStartDate());
    visitPlanRouteRangeModel.setEndDate(visitPlanLineRange.getLoopsEndDate());
    return visitPlanRouteRangeModel;
  }
}
