package com.biz.crm.sfa.business.visit.plan.line.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.sfa.visit.plan.line.sdk.dto.VisitPlanLineQueryDto;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLine;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 拜访计划线路组表(VisitPlanLine)表相关的http接口
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
@RestController
@RequestMapping("/v1/visitPlanLine/visitPlanLine")
@Slf4j
@Api(tags = "拜访计划线路组:VisitPlanLine:拜访计划线路组表")
public class VisitPlanLineController {
  /**
   * 服务对象
   */
  @Autowired
  private VisitPlanLineService visitPlanLineService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto      查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<VisitPlanLine>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                      @ApiParam(name = "visitPlanLine", value = "拜访计划线路组表") VisitPlanLineQueryDto dto) {
    try {
      Page<VisitPlanLine> page = this.visitPlanLineService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param visitPlanLine 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<VisitPlanLine> create(@ApiParam(name = "visitPlanLine", value = "拜访计划线路组表") @RequestBody VisitPlanLine visitPlanLine) {
    try {
      VisitPlanLine result = this.visitPlanLineService.create(visitPlanLine);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   *
   * @param visitPlanLine 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<VisitPlanLine> update(@ApiParam(name = "visitPlanLine", value = "拜访计划线路组表") @RequestBody VisitPlanLine visitPlanLine) {
    try {
      VisitPlanLine result = this.visitPlanLineService.update(visitPlanLine);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   * - 因为网关问题未修复好
   * - 为小程序不能发起patch请求
   *
   * @param visitPlanLine 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PostMapping("updateTurnPatch")
  public Result<VisitPlanLine> updateTurnPatch(@ApiParam(name = "visitPlanLine", value = "拜访计划线路组表") @RequestBody VisitPlanLine visitPlanLine) {
    return this.update(visitPlanLine);
  }

  /**
   * 删除数据
   *
   * @param ids 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.visitPlanLineService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  @PatchMapping("enable")
  @ApiOperation(value = "启用（单个或者批量）")
  public Result<?> enable(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.visitPlanLineService.enable(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  @PatchMapping("disable")
  @ApiOperation(value = "禁用（单个或者批量）")
  public Result<?> disable(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.visitPlanLineService.disable(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
