package com.biz.crm.sfa.business.visit.plan.line.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineVo;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 拜访计划线路组vo(VisitPlanLineVo)相关的http接口
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
@RestController
@RequestMapping("/v1/visitPlanLine/visitPlanLineVo")
@Slf4j
@Api(tags = "拜访计划线路组:VisitPlanLineVo:拜访计划线路组vo")
public class VisitPlanLineVoController {
  /**
   * 服务对象
   */
  @Autowired
  private VisitPlanLineVoService visitPlanLineVoService;

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<VisitPlanLineVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      VisitPlanLineVo visitPlanLine = this.visitPlanLineVoService.findById(id);
      return Result.ok(visitPlanLine);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
