package com.biz.crm.sfa.business.visit.plan.line.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitWeekTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.Set;

/**
 * 线路组拜访信息实体类
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_visit_plan_line_range")
@Table(name = "sfa_visit_plan_line_range", indexes = {
    @Index(name = "sfa_visit_plan_line_range_index1", columnList = "visit_plan_code", unique = true),
})
@ApiModel(value = "VisitPlanLineRange", description = "线路组拜访信息表")
@org.hibernate.annotations.Table(appliesTo = "sfa_visit_plan_line_range", comment = "线路组拜访信息表")
public class VisitPlanLineRange extends UuidEntity {

  private static final long serialVersionUID = -602205621706536654L;
  /**
   * 拜访计划编码
   */
  @ApiModelProperty("拜访计划编码")
  @Column(name = "visit_plan_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '拜访计划编码'")
  private String visitPlanCode;

  /**
   * 循环开始日期
   */
  @ApiModelProperty("循环开始日期")
  @Column(name = "loops_start_date", length = 20, nullable = false, columnDefinition = "date COMMENT '循环开始日期'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date loopsStartDate;

  /**
   * 循环结束日期
   */
  @ApiModelProperty("循环结束日期")
  @Column(name = "loops_end_date", length = 20, nullable = false, columnDefinition = "date COMMENT '循环结束日期'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date loopsEndDate;

  /**
   * 排除星期类型集合字符串（星期一、星期二、星期三、星期四、星期五、星期六、星期日）
   * {@link VisitWeekTypeEnum#getDictCode()}
   */
  @ApiModelProperty("排除星期类型集合字符串,例如： Mon,Sun")
  @Column(name = "not_week_set", length = 255, columnDefinition = "varchar(255) COMMENT '排除星期类型集合字符串,例如:Mon,Sun'")
  private String notWeekSet;

  /**
   * 关联线路组集合
   */
  @ApiModelProperty("关联线路组集合")
  @TableField(exist = false)
  @Transient
  private Set<VisitPlanLineRangeMapping> visitPlanLineRangeMappings;

}
