package com.biz.crm.sfa.business.visit.plan.line.local.observer;

import com.biz.crm.business.sfa.visit.plan.line.sdk.service.VisitPlanLineRangeClientInfoVoService;
import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineRangeClientInfoVo;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRange;
import com.biz.crm.sfa.business.visit.plan.line.local.register.VisitPlanLineRouteRegister;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineRangeService;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitWeekTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanDetailModel;
import com.biz.crm.sfa.business.visit.plan.sdk.observer.VisitPlanDetailObserver;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 拜访计划线路组观察者实现类
 *
 * @author songjingen
 */
@Component
public class VisitPlanDetailLineObserver implements VisitPlanDetailObserver {

  @Autowired
  private VisitPlanLineRouteRegister visitPlanLineRouteRegister;

  @Autowired
  private VisitPlanLineRangeService visitPlanLineRangeService;

  @Autowired
  private VisitPlanLineRangeClientInfoVoService visitPlanLineRangeClientInfoVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private VisitPlanDetailVoService visitPlanDetailVoService;

  @Override
  public List<VisitPlanDetailModel> onRequestVisitDetailDto(Map<String, List<String>> map) {
    if (map == null) {
      return new ArrayList<>(0);
    }
    List<String> visitPlanCodes = map.get(visitPlanLineRouteRegister.getKey());
    if (CollectionUtils.isEmpty(visitPlanCodes)) {
      return new ArrayList<>(0);
    }
    List<VisitPlanLineRange> visitPlanLineRanges = this.visitPlanLineRangeService.findByVisitPlanCodes(visitPlanCodes);
    if (CollectionUtils.isEmpty(visitPlanLineRanges)) {
      return new ArrayList<>(0);
    }
    List<String> rangeIds = visitPlanLineRanges.stream().map(VisitPlanLineRange::getId).collect(Collectors.toList());
    //按照rangeId分组后的map
    List<VisitPlanDetailModel> visitPlanDetailModels = new ArrayList<>();
    SimpleDateFormat weekSdf = new SimpleDateFormat("EE", Locale.CHINA);
    Map<String, List<VisitPlanLineRangeClientInfoVo>> clientInfoMap = this.visitPlanLineRangeClientInfoVoService.findByRangeIds(rangeIds);
    for (VisitPlanLineRange visitPlanLineRange : visitPlanLineRanges) {
      List<VisitPlanLineRangeClientInfoVo> visitPlanLineRangeClientInfoVos = clientInfoMap.get(visitPlanLineRange.getId());
      if (CollectionUtils.isEmpty(visitPlanLineRangeClientInfoVos)) {
        continue;
      }
      String notWeekSet = visitPlanLineRange.getNotWeekSet();
      List<String> weekValues = new ArrayList<>();
      if (StringUtils.isNotBlank(notWeekSet)) {
        String[] split = notWeekSet.split(",");
        weekValues = VisitWeekTypeEnum.getValuesByDictCodes(Lists.newArrayList(split));
      }
      Date loopsStartDate = visitPlanLineRange.getLoopsStartDate();
      Date loopsEndDate = visitPlanLineRange.getLoopsEndDate();
      //计算天数
      int dayDiffer = this.getDayDiffer(loopsStartDate, loopsEndDate);
      //按照线路组编码分组
      Map<String, List<VisitPlanLineRangeClientInfoVo>> mapByLineCode = visitPlanLineRangeClientInfoVos.stream().collect(Collectors.groupingBy(VisitPlanLineRangeClientInfoVo::getLineCode));
      //循环日期天数生成明细model
      for (int i = 0; i < dayDiffer; i++) {
        Date visitDate = DateUtils.addDays(loopsStartDate, i);
        //排除星期
        String week = weekSdf.format(visitDate);
        if (weekValues.contains(week)) {
          continue;
        }
        //循环线路组，并且客户信息正序
        for (Map.Entry<String, List<VisitPlanLineRangeClientInfoVo>> entity : mapByLineCode.entrySet()) {
          entity.getValue().stream().sorted(Comparator.comparing(VisitPlanLineRangeClientInfoVo::getClientOrder));
          List<VisitPlanDetailModel> models = (List<VisitPlanDetailModel>) this.nebulaToolkitService.copyCollectionByWhiteList(entity.getValue(), VisitPlanLineRangeClientInfoVo.class, VisitPlanDetailModel.class, HashSet.class, ArrayList.class);
          models.stream().forEach(visitPlanDetailModel -> {
            visitPlanDetailModel.setVisitDate(visitDate);
            visitPlanDetailModel.setVisitStatus(VisitStatusEnum.NOT_VISIT.getDictCode());
            visitPlanDetailModel.setVisitPlanCode(visitPlanLineRange.getVisitPlanCode());
          });
          visitPlanDetailModels.addAll(models);
        }
      }
    }
    return visitPlanDetailModels;
  }

  @Override
  @Transactional
  public void onCreate(Map<String, List<String>> map) {
    List<VisitPlanDetailModel> visitPlanDetailModels = this.onRequestVisitDetailDto(map);
    if (!CollectionUtils.isEmpty(visitPlanDetailModels)) {
      this.visitPlanDetailVoService.createBatch(visitPlanDetailModels);
    }
  }

  @Transactional
  @Override
  public void onUpdate(Map<String, List<String>> map) {
    List<VisitPlanDetailModel> visitPlanDetailModels = this.onRequestVisitDetailDto(map);
    if (!CollectionUtils.isEmpty(visitPlanDetailModels)) {
      this.visitPlanDetailVoService.updateBatch(visitPlanDetailModels);
    }
  }

  /**
   * 计算开始时间，结束时间，间隔天数
   *
   * @param startDate
   * @param endDate
   * @return
   */
  private int getDayDiffer(Date startDate, Date endDate) {
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    long startDateTime = 0;
    long endDateTime = 0;
    try {
      startDateTime = dateFormat.parse(dateFormat.format(startDate)).getTime();
      endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
    } catch (ParseException e) {
      e.printStackTrace();
    }
    return (int) ((endDateTime - startDateTime) / (1000 * 3600 * 24)) + 1;
  }

}
