package com.biz.crm.sfa.business.visit.plan.line.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineClientInfo;
import com.biz.crm.sfa.business.visit.plan.line.local.mapper.VisitPlanLineClientInfoMapper;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 拜访计划制定表(VisitPlanLineClientInfo)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
@Component
public class VisitPlanLineClientInfoRepository extends ServiceImpl<VisitPlanLineClientInfoMapper, VisitPlanLineClientInfo> {

  /**
   * 根据线路组编码删除数据
   *
   * @param lineCode
   */
  public void deleteByLineCode(String lineCode) {
    this.lambdaUpdate().eq(VisitPlanLineClientInfo::getLineCode, lineCode).remove();
  }

  /**
   * 根据线路组编码查询数据
   *
   * @param lineCode
   */
  public List<VisitPlanLineClientInfo> findByLineCode(String lineCode) {
    return this.lambdaQuery().eq(VisitPlanLineClientInfo::getLineCode, lineCode).list();
  }

  /**
   * 通过线路组编码查询数据
   *
   * @param lineCodes
   * @return
   */
  public List<VisitPlanLineClientInfo> findByLineCodes(Set<String> lineCodes) {
    return this.lambdaQuery().in(VisitPlanLineClientInfo::getLineCode, lineCodes).list();
  }
}

