package com.biz.crm.sfa.business.visit.plan.line.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRange;
import com.biz.crm.sfa.business.visit.plan.line.local.mapper.VisitPlanLineRangeMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 线路组拜访信息表(VisitPlanLineRange)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
@Component
public class VisitPlanLineRangeRepository extends ServiceImpl<VisitPlanLineRangeMapper, VisitPlanLineRange> {

  /**
   * 根据拜访计划编码删除数据
   *
   * @param visitPlanCode
   */
  public void deleteByVisitPlanCode(String visitPlanCode) {
    this.lambdaUpdate().eq(VisitPlanLineRange::getVisitPlanCode, visitPlanCode).remove();
  }

  /**
   * 根据拜访计划编码查询对象
   *
   * @param visitPlanCode
   * @return
   */
  public VisitPlanLineRange findByVisitPlanCode(String visitPlanCode) {
    return this.lambdaQuery().eq(VisitPlanLineRange::getVisitPlanCode, visitPlanCode).one();
  }

  /**
   * 根据拜访计划编码查询基础信息集合
   *
   * @param visitPlanCodes
   * @return
   */
  public List<VisitPlanLineRange> findByVisitPlanCodes(List<String> visitPlanCodes) {
    return this.lambdaQuery().in(VisitPlanLineRange::getVisitPlanCode, visitPlanCodes).list();
  }
}

