package com.biz.crm.sfa.business.visit.plan.line.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.sfa.visit.plan.line.sdk.dto.VisitPlanLineQueryDto;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLine;
import com.biz.crm.sfa.business.visit.plan.line.local.mapper.VisitPlanLineMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 拜访计划线路组表(VisitPlanLine)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
@Component
public class VisitPlanLineRepository extends ServiceImpl<VisitPlanLineMapper, VisitPlanLine> {

  @Autowired
  private VisitPlanLineMapper visitPlanLineMapper;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  public Page<VisitPlanLine> findByConditions(Pageable pageable, VisitPlanLineQueryDto dto) {
    Page<VisitPlanLine> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<VisitPlanLine> pageList = this.visitPlanLineMapper.findByConditions(page, dto);
    return pageList;
  }

  /**
   * 根据id集合更新启禁用装填
   *
   * @param ids          分页对象
   * @param enableStatus 启禁用状态对象
   * @return
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(VisitPlanLine::getId, ids)
        .set(VisitPlanLine::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 按照人员账号和线路组名称查询数据
   *
   * @param userName 人员账号
   * @param lineName 线路名称
   * @return
   */
  public List<VisitPlanLine> findByUserNameAndLineName(String userName, String lineName) {
    return this.lambdaQuery()
        .eq(VisitPlanLine::getUserName, userName)
        .eq(VisitPlanLine::getLineName, lineName)
        .list();
  }

  /**
   * 更新删除状态
   *
   * @param idList
   */
  public void updateDelFlagByIds(List<String> idList, DelFlagStatusEnum delFlagStatusEnum) {
    this.lambdaUpdate().in(VisitPlanLine::getId, idList).set(VisitPlanLine::getDelFlag, delFlagStatusEnum.getCode()).update();
  }

  /**
   * 根据id集合查询数据
   *
   * @param idList
   * @return
   */
  public List<VisitPlanLine> findByIds(List<String> idList) {
    return this.lambdaQuery().in(VisitPlanLine::getId, idList).list();
  }
}

