package com.biz.crm.sfa.business.visit.plan.line.local.service;


import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineClientInfo;

import java.util.List;

/**
 * 拜访计划制定表(VisitPlanLineClientInfo)表服务接口
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
public interface VisitPlanLineClientInfoService {

  /**
   * 根据线路组编码删除数据
   *
   * @param lineCode 线路组编码集合
   * @return 删除结果
   */
  void deleteByLineCode(String lineCode);

  /**
   * 批量新增数据
   *
   * @param visitPlanLineClientInfos
   */
  void createBatch(List<VisitPlanLineClientInfo> visitPlanLineClientInfos);

  /**
   * 根据线路组编码查询数据
   *
   * @param lineCode 线路组编码
   * @return 客户信息集合
   */
  List<VisitPlanLineClientInfo> findByLineCode(String lineCode);
}

