package com.biz.crm.sfa.business.visit.plan.line.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.sfa.visit.plan.line.sdk.dto.VisitPlanLineQueryDto;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLine;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 拜访计划线路组表(VisitPlanLine)表服务接口
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
public interface VisitPlanLineService {

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  Page<VisitPlanLine> findByConditions(Pageable pageable, VisitPlanLineQueryDto dto);

  /**
   * 新增数据
   *
   * @param visitPlanLine 实体对象
   * @return 新增结果
   */
  VisitPlanLine create(VisitPlanLine visitPlanLine);

  /**
   * 修改新据
   *
   * @param visitPlanLine 实体对象
   * @return 修改结果
   */
  VisitPlanLine update(VisitPlanLine visitPlanLine);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);

  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);

}

