package com.biz.crm.sfa.business.visit.plan.line.local.service.internal;


import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRange;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRangeMapping;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineRangeMappingRepository;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineRangeRepository;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineRangeMappingService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 线路组和线路组拜访信息关系表(VisitPlanLineRangeMapping)表服务实现类
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
@Service("visitPlanLineRangeMappingService")
public class VisitPlanLineRangeMappingServiceImpl implements VisitPlanLineRangeMappingService {

  @Autowired
  private VisitPlanLineRangeMappingRepository visitPlanLineRangeMappingRepository;
  @Autowired
  private VisitPlanLineRangeRepository visitPlanLineRangeRepository;

  /**
   * 新增数据（批量）
   *
   * @param visitPlanLineRangeMappingSet 实体对象集合
   * @return
   */
  @Transactional
  @Override
  public void createBatch(Set<VisitPlanLineRangeMapping> visitPlanLineRangeMappingSet) {
    Validate.isTrue(!CollectionUtils.isEmpty(visitPlanLineRangeMappingSet), "批量新增数据时，集合不能为空！");
    visitPlanLineRangeMappingSet.stream().forEach(visitPlanLineRangeMapping -> this.createValidate(visitPlanLineRangeMapping));
    this.visitPlanLineRangeMappingRepository.saveBatch(visitPlanLineRangeMappingSet);
  }

  @Transactional
  @Override
  public void deleteByRangeId(String rangeId) {
    this.visitPlanLineRangeMappingRepository.deleteByRangeId(rangeId);
  }

  @Override
  public Set<VisitPlanLineRangeMapping> findByRangeId(String rangeId) {
    if (StringUtils.isBlank(rangeId)) {
      return new HashSet<>(0);
    }
    List<VisitPlanLineRangeMapping> lineRangeMappings = this.visitPlanLineRangeMappingRepository.findByRangeId(rangeId);
    if (CollectionUtils.isEmpty(lineRangeMappings)) {
      return new HashSet<>(0);
    }
    return new HashSet<>(lineRangeMappings);
  }

  @Override
  public Map<String, List<VisitPlanLineRangeMapping>> findByVisitPlanCodesStuMap(List<String> visitPlanCodes) {
    if (CollectionUtils.isEmpty(visitPlanCodes)) {
      return null;
    }
    List<VisitPlanLineRange> visitPlanLineRanges = this.visitPlanLineRangeRepository.findByVisitPlanCodes(visitPlanCodes);
    if (CollectionUtils.isEmpty(visitPlanLineRanges)) {
      return null;
    }
    List<String> rangeIds = visitPlanLineRanges.stream().map(VisitPlanLineRange::getId).collect(Collectors.toList());
    List<VisitPlanLineRangeMapping> visitPlanLineRangeMappings = this.visitPlanLineRangeMappingRepository.findByRangeIds(rangeIds);
    Map<String, List<VisitPlanLineRangeMapping>> map = new HashMap<>();
    if (!CollectionUtils.isEmpty(visitPlanLineRangeMappings)) {
      map = visitPlanLineRangeMappings.stream().collect(Collectors.groupingBy(VisitPlanLineRangeMapping::getRangeId));
    }
    //组装返回数据,k-visitPlanCode,value-List<VisitPlanLineRangeMapping>
    Map<String, List<VisitPlanLineRangeMapping>> voMap = new HashMap<>();
    for (VisitPlanLineRange visitPlanLineRange : visitPlanLineRanges) {
      String id = visitPlanLineRange.getId();
      List<VisitPlanLineRangeMapping> mappings = map.get(id);
      if (!CollectionUtils.isEmpty(mappings)) {
        voMap.put(visitPlanLineRange.getVisitPlanCode(), mappings);
      }
    }
    return voMap;
  }

  /**
   * 创建验证
   *
   * @param visitPlanLineRangeMapping
   */
  private void createValidate(VisitPlanLineRangeMapping visitPlanLineRangeMapping) {
    Validate.notNull(visitPlanLineRangeMapping, "新增时，对象信息不能为空！");
    visitPlanLineRangeMapping.setId(null);
    Validate.notBlank(visitPlanLineRangeMapping.getLineCode(), "新增数据时，线路组编码不能为空！");
    Validate.notBlank(visitPlanLineRangeMapping.getLineName(), "新增数据时，线路组名称不能为空！");
    Validate.notBlank(visitPlanLineRangeMapping.getRangeId(), "新增数据时，线路组拜访信息id不能为空！");
  }

}

