package com.biz.crm.sfa.business.visit.plan.line.local.service.internal;


import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineRangeMappingVo;
import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineRouteRangeVo;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineClientInfo;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRange;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRangeMapping;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineClientInfoRepository;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineRangeRepository;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineRangeMappingService;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineRangeService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 线路组拜访信息表(VisitPlanLineRange)表服务实现类
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
@Service("visitPlanLineRangeService")
public class VisitPlanLineRangeServiceImpl implements VisitPlanLineRangeService {

  @Autowired
  private VisitPlanLineRangeRepository visitPlanLineRangeRepository;

  @Autowired
  private VisitPlanLineRangeMappingService visitPlanLineRangeMappingService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private VisitPlanLineClientInfoRepository visitPlanLineClientInfoRepository;

  /**
   * 新增数据
   *
   * @param visitPlanLineRange 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public VisitPlanLineRange create(VisitPlanLineRange visitPlanLineRange) {
    this.createValidate(visitPlanLineRange);
    this.visitPlanLineRangeRepository.saveOrUpdate(visitPlanLineRange);
    //保存关联线路表
    Set<VisitPlanLineRangeMapping> visitPlanLineRangeMappings = visitPlanLineRange.getVisitPlanLineRangeMappings();
    visitPlanLineRangeMappings.stream().forEach(visitPlanLineRangeMapping -> visitPlanLineRangeMapping.setRangeId(visitPlanLineRange.getId()));
    this.visitPlanLineRangeMappingService.createBatch(visitPlanLineRangeMappings);
    return visitPlanLineRange;
  }

  /**
   * 修改新据
   *
   * @param visitPlanLineRange 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public VisitPlanLineRange update(VisitPlanLineRange visitPlanLineRange) {
    //删除数据
    VisitPlanLineRange planLineRange = this.visitPlanLineRangeRepository.findByVisitPlanCode(visitPlanLineRange.getVisitPlanCode());
    if (planLineRange != null) {
      try {
        String nowDateStr = DateFormatUtils.format(new Date(), "yyyy-MM-dd");
        Date nowDate = DateUtils.parseDate(nowDateStr, "yyyy-MM-dd");
        Validate.isTrue(visitPlanLineRange.getLoopsEndDate().after(nowDate), "修改时，循环结束时间小于当前时间不允许修改！");
      } catch (ParseException e) {
        e.printStackTrace();
      }
      this.visitPlanLineRangeMappingService.deleteByRangeId(planLineRange.getId());
      this.visitPlanLineRangeRepository.deleteByVisitPlanCode(visitPlanLineRange.getVisitPlanCode());
    }
    //新增数据
    this.create(visitPlanLineRange);
    return visitPlanLineRange;
  }

  @Override
  public VisitPlanLineRouteRangeVo findByVisitPlanCode(String visitPlanCode) {
    if (StringUtils.isBlank(visitPlanCode)) {
      return null;
    }
    VisitPlanLineRange byVisitPlanCode = this.visitPlanLineRangeRepository.findByVisitPlanCode(visitPlanCode);
    if (byVisitPlanCode == null) {
      return null;
    }
    VisitPlanLineRouteRangeVo visitPlanLineRouteRangeVo = this.nebulaToolkitService.copyObjectByWhiteList(byVisitPlanCode, VisitPlanLineRouteRangeVo.class, HashSet.class, ArrayList.class);
    Set<VisitPlanLineRangeMapping> visitPlanLineRangeMappingSet = this.visitPlanLineRangeMappingService.findByRangeId(byVisitPlanCode.getId());
    if (!CollectionUtils.isEmpty(visitPlanLineRangeMappingSet)) {
      Set<VisitPlanLineRangeMappingVo> visitPlanLineRangeMappingVos = (Set<VisitPlanLineRangeMappingVo>) this.nebulaToolkitService.copyCollectionByWhiteList(visitPlanLineRangeMappingSet, VisitPlanLineRangeMapping.class, VisitPlanLineRangeMappingVo.class, HashSet.class, ArrayList.class);
      Set<String> lineCodes = visitPlanLineRangeMappingVos.stream().map(VisitPlanLineRangeMappingVo::getLineCode).collect(Collectors.toSet());
      List<VisitPlanLineClientInfo> clientInfos = this.visitPlanLineClientInfoRepository.findByLineCodes(lineCodes);
      Map<String, Long> clientCountMap = new HashMap<>();
      if (!CollectionUtils.isEmpty(clientInfos)) {
        clientCountMap = clientInfos.stream().collect(Collectors.groupingBy(VisitPlanLineClientInfo::getLineCode, Collectors.counting()));
      }
      for (VisitPlanLineRangeMappingVo o : visitPlanLineRangeMappingVos) {
        o.setClientCount(clientCountMap.get(o.getLineCode()));
      }
      visitPlanLineRouteRangeVo.setVisitPlanLineRangeMappings(visitPlanLineRangeMappingVos);
    }
    return visitPlanLineRouteRangeVo;
  }

  @Override
  public List<VisitPlanLineRange> findByVisitPlanCodes(List<String> visitPlanCodes) {
    if (CollectionUtils.isEmpty(visitPlanCodes)) {
      return new ArrayList<>(0);
    }
    return this.visitPlanLineRangeRepository.findByVisitPlanCodes(visitPlanCodes);
  }

  /**
   * 创建验证
   *
   * @param visitPlanLineRange
   */
  private void createValidate(VisitPlanLineRange visitPlanLineRange) {
    Validate.notNull(visitPlanLineRange, "新增时，对象信息不能为空！");
    visitPlanLineRange.setId(null);
    Validate.notNull(visitPlanLineRange.getLoopsEndDate(), "新增数据时，循环结束日期不能为空！");
    Validate.notNull(visitPlanLineRange.getLoopsStartDate(), "新增数据时，循环开始日期不能为空！");
    Validate.notBlank(visitPlanLineRange.getVisitPlanCode(), "新增数据时，拜访计划编码不能为空！");
    Validate.isTrue(!CollectionUtils.isEmpty(visitPlanLineRange.getVisitPlanLineRangeMappings()), "新增数据时，关联线路组不能为空！");
    try {
      String nowDateStr = DateFormatUtils.format(new Date(), "yyyy-MM-dd");
      Date nowDate = DateUtils.parseDate(nowDateStr, "yyyy-MM-dd");
      Validate.isTrue(visitPlanLineRange.getLoopsStartDate().compareTo(nowDate) >= 0, "循环开始日期必须大于或者等于当前日期！");
      Validate.isTrue(visitPlanLineRange.getLoopsEndDate().compareTo(visitPlanLineRange.getLoopsStartDate()) >= 0, "循环开始日期必须小于或者等于循环结束日期！");
    } catch (ParseException e) {
      e.printStackTrace();
    }
  }

}

