package com.biz.crm.sfa.business.visit.plan.line.local.service.internal;


import cn.hutool.core.bean.BeanUtil;
import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineClientInfoVo;
import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLine;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineClientInfo;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineRepository;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineClientInfoService;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 拜访计划线路组vo(VisitPlanLineVo)服务实现类
 *
 * @author songjingen
 * @since 2022-05-07 14:08:18
 */
@Service("visitPlanLineVoService")
public class VisitPlanLineVoServiceImpl implements VisitPlanLineVoService {

  @Autowired
  private VisitPlanLineRepository visitPlanLineRepository;

  @Autowired
  private VisitPlanLineClientInfoService visitPlanLineClientInfoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private List<ClientRouteStrategy> visitPlanClientRouteStrategies;


  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public VisitPlanLineVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    VisitPlanLine visitPlanLine = this.visitPlanLineRepository.getById(id);
    if (visitPlanLine == null) {
      return null;
    }
    VisitPlanLineVo visitPlanLineVo = this.nebulaToolkitService.copyObjectByBlankList(visitPlanLine, VisitPlanLineVo.class, HashSet.class, ArrayList.class);
    List<VisitPlanLineClientInfo> visitPlanLineClientInfos = this.visitPlanLineClientInfoService.findByLineCode(visitPlanLine.getLineCode());
    List<VisitPlanLineClientInfoVo> visitPlanLineClientInfoVos = this.buildVisitPlanLineClientInfo(visitPlanLineClientInfos);
    visitPlanLineVo.setVisitPlanLineClientInfoVos(visitPlanLineClientInfoVos);
    return visitPlanLineVo;
  }


  /**
   * 组装客户信息数据
   *
   * @param visitPlanLineClientInfos
   * @return
   */
  private List<VisitPlanLineClientInfoVo> buildVisitPlanLineClientInfo(List<VisitPlanLineClientInfo> visitPlanLineClientInfos) {
    if (CollectionUtils.isEmpty(visitPlanLineClientInfos)) {
      return new ArrayList<>(0);
    }
    //Map<clientRoute, Map<clientType, List<clientCode>>>
    Map<String, Map<String, List<String>>> clientMap = visitPlanLineClientInfos.stream()
        .collect(
            Collectors.groupingBy(VisitPlanLineClientInfo::getClientRoute,
                Collectors.groupingBy(VisitPlanLineClientInfo::getClientType, Collectors.mapping(VisitPlanLineClientInfo::getClientCode, Collectors.toList())
                )));
    //判断客户维度策略
    Map<String, List<ClientRouteInfoVo>> infoVoHashMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(visitPlanClientRouteStrategies)) {
      List<ClientRouteInfoVo> infoVos = new ArrayList<>();
      for (ClientRouteStrategy clientRouteStrategy : visitPlanClientRouteStrategies) {
        Map<String, List<String>> listMap = clientMap.get(clientRouteStrategy.getKey());
        if (listMap != null) {
          List<ClientRouteInfoVo> terminalVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.TERMINAL.getDictCode()), ClientTypeEnum.TERMINAL.getDictCode());
          List<ClientRouteInfoVo> dealerVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.DEALER.getDictCode()), ClientTypeEnum.DEALER.getDictCode());
          infoVos.addAll(terminalVos);
          infoVos.addAll(dealerVos);
        }
      }
      if (!CollectionUtils.isEmpty(infoVos)) {
        infoVoHashMap = infoVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith("_", o.getClientRoute(), o.getClientType(), o.getClientCode())));
      }
    }
    //循环赋值
    List<VisitPlanLineClientInfoVo> visitPlanLineClientInfoVos = new ArrayList<>();
    for (VisitPlanLineClientInfo visitPlanLineClientInfo : visitPlanLineClientInfos) {
      VisitPlanLineClientInfoVo visitPlanLineClientInfoVo = this.nebulaToolkitService.copyObjectByBlankList(visitPlanLineClientInfo, VisitPlanLineClientInfoVo.class, HashSet.class, ArrayList.class);
      visitPlanLineClientInfoVos.add(visitPlanLineClientInfoVo);
      String key = StringUtils.joinWith("_", visitPlanLineClientInfo.getClientRoute(), visitPlanLineClientInfo.getClientType(), visitPlanLineClientInfo.getClientCode());
      List<ClientRouteInfoVo> infoVos = infoVoHashMap.get(key);
      if (CollectionUtils.isEmpty(infoVos)) {
        continue;
      }
      ClientRouteInfoVo vo = infoVos.get(0);
      BeanUtil.copyProperties(vo, visitPlanLineClientInfoVo);
      visitPlanLineClientInfoVo.setAddress(vo.getClientAddress());
    }
    return visitPlanLineClientInfoVos;
  }
}

