/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.line.local.observer;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.sfa.visit.plan.line.sdk.service.VisitPlanLineRangeClientInfoVoService;
import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineRangeClientInfoVo;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRange;
import com.biz.crm.sfa.business.visit.plan.line.local.register.VisitPlanLineRouteRegister;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineRangeService;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitWeekTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanDetailModel;
import com.biz.crm.sfa.business.visit.plan.sdk.observer.VisitPlanDetailObserver;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class VisitPlanDetailLineObserver
implements VisitPlanDetailObserver {
    @Autowired
    private VisitPlanLineRouteRegister visitPlanLineRouteRegister;
    @Autowired
    private VisitPlanLineRangeService visitPlanLineRangeService;
    @Autowired
    private VisitPlanLineRangeClientInfoVoService visitPlanLineRangeClientInfoVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private VisitPlanDetailVoService visitPlanDetailVoService;

    public List<VisitPlanDetailModel> onRequestVisitDetailDto(Map<String, List<String>> map) {
        if (map == null) {
            return new ArrayList<VisitPlanDetailModel>(0);
        }
        List<String> visitPlanCodes = map.get(this.visitPlanLineRouteRegister.getKey());
        if (CollectionUtils.isEmpty(visitPlanCodes)) {
            return new ArrayList<VisitPlanDetailModel>(0);
        }
        List<VisitPlanLineRange> visitPlanLineRanges = this.visitPlanLineRangeService.findByVisitPlanCodes(visitPlanCodes);
        if (CollectionUtils.isEmpty(visitPlanLineRanges)) {
            return new ArrayList<VisitPlanDetailModel>(0);
        }
        List rangeIds = visitPlanLineRanges.stream().map(UuidEntity::getId).collect(Collectors.toList());
        ArrayList<VisitPlanDetailModel> visitPlanDetailModels = new ArrayList<VisitPlanDetailModel>();
        SimpleDateFormat weekSdf = new SimpleDateFormat("EE", Locale.CHINA);
        Map clientInfoMap = this.visitPlanLineRangeClientInfoVoService.findByRangeIds(rangeIds);
        for (VisitPlanLineRange visitPlanLineRange : visitPlanLineRanges) {
            List visitPlanLineRangeClientInfoVos = (List)clientInfoMap.get(visitPlanLineRange.getId());
            if (CollectionUtils.isEmpty((Collection)visitPlanLineRangeClientInfoVos)) continue;
            String notWeekSet = visitPlanLineRange.getNotWeekSet();
            List weekValues = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)notWeekSet)) {
                Object[] split = notWeekSet.split(",");
                weekValues = VisitWeekTypeEnum.getValuesByDictCodes((List)Lists.newArrayList((Object[])split));
            }
            Date loopsStartDate = visitPlanLineRange.getLoopsStartDate();
            Date loopsEndDate = visitPlanLineRange.getLoopsEndDate();
            int dayDiffer = this.getDayDiffer(loopsStartDate, loopsEndDate);
            Map<String, List<VisitPlanLineRangeClientInfoVo>> mapByLineCode = visitPlanLineRangeClientInfoVos.stream().collect(Collectors.groupingBy(VisitPlanLineRangeClientInfoVo::getLineCode));
            for (int i = 0; i < dayDiffer; ++i) {
                Date visitDate = DateUtils.addDays((Date)loopsStartDate, (int)i);
                String week = weekSdf.format(visitDate);
                if (weekValues.contains(week)) continue;
                for (Map.Entry<String, List<VisitPlanLineRangeClientInfoVo>> entity : mapByLineCode.entrySet()) {
                    entity.getValue().stream().sorted(Comparator.comparing(VisitPlanLineRangeClientInfoVo::getClientOrder));
                    List models = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entity.getValue(), VisitPlanLineRangeClientInfoVo.class, VisitPlanDetailModel.class, HashSet.class, ArrayList.class, new String[0]);
                    models.stream().forEach(visitPlanDetailModel -> {
                        visitPlanDetailModel.setVisitDate(visitDate);
                        visitPlanDetailModel.setVisitStatus(VisitStatusEnum.NOT_VISIT.getDictCode());
                        visitPlanDetailModel.setVisitPlanCode(visitPlanLineRange.getVisitPlanCode());
                    });
                    visitPlanDetailModels.addAll(models);
                }
            }
        }
        return visitPlanDetailModels;
    }

    @Transactional
    public void onCreate(Map<String, List<String>> map) {
        List<VisitPlanDetailModel> visitPlanDetailModels = this.onRequestVisitDetailDto(map);
        if (!CollectionUtils.isEmpty(visitPlanDetailModels)) {
            this.visitPlanDetailVoService.createBatch(visitPlanDetailModels);
        }
    }

    @Transactional
    public void onUpdate(Map<String, List<String>> map) {
        List<VisitPlanDetailModel> visitPlanDetailModels = this.onRequestVisitDetailDto(map);
        if (!CollectionUtils.isEmpty(visitPlanDetailModels)) {
            this.visitPlanDetailVoService.updateBatch(visitPlanDetailModels);
        }
    }

    private int getDayDiffer(Date startDate, Date endDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        long startDateTime = 0L;
        long endDateTime = 0L;
        try {
            startDateTime = dateFormat.parse(dateFormat.format(startDate)).getTime();
            endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return (int)((endDateTime - startDateTime) / 86400000L) + 1;
    }
}

