/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.line.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRange;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRangeMapping;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineRangeMappingRepository;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineRangeRepository;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineRangeMappingService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="visitPlanLineRangeMappingService")
public class VisitPlanLineRangeMappingServiceImpl
implements VisitPlanLineRangeMappingService {
    @Autowired
    private VisitPlanLineRangeMappingRepository visitPlanLineRangeMappingRepository;
    @Autowired
    private VisitPlanLineRangeRepository visitPlanLineRangeRepository;

    @Override
    @Transactional
    public void createBatch(Set<VisitPlanLineRangeMapping> visitPlanLineRangeMappingSet) {
        Validate.isTrue((!CollectionUtils.isEmpty(visitPlanLineRangeMappingSet) ? 1 : 0) != 0, (String)"\u6279\u91cf\u65b0\u589e\u6570\u636e\u65f6\uff0c\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        visitPlanLineRangeMappingSet.stream().forEach(visitPlanLineRangeMapping -> this.createValidate((VisitPlanLineRangeMapping)((Object)visitPlanLineRangeMapping)));
        this.visitPlanLineRangeMappingRepository.saveBatch(visitPlanLineRangeMappingSet);
    }

    @Override
    @Transactional
    public void deleteByRangeId(String rangeId) {
        this.visitPlanLineRangeMappingRepository.deleteByRangeId(rangeId);
    }

    @Override
    public Set<VisitPlanLineRangeMapping> findByRangeId(String rangeId) {
        if (StringUtils.isBlank((CharSequence)rangeId)) {
            return new HashSet<VisitPlanLineRangeMapping>(0);
        }
        List<VisitPlanLineRangeMapping> lineRangeMappings = this.visitPlanLineRangeMappingRepository.findByRangeId(rangeId);
        if (CollectionUtils.isEmpty(lineRangeMappings)) {
            return new HashSet<VisitPlanLineRangeMapping>(0);
        }
        return new HashSet<VisitPlanLineRangeMapping>(lineRangeMappings);
    }

    @Override
    public Map<String, List<VisitPlanLineRangeMapping>> findByVisitPlanCodesStuMap(List<String> visitPlanCodes) {
        if (CollectionUtils.isEmpty(visitPlanCodes)) {
            return null;
        }
        List<VisitPlanLineRange> visitPlanLineRanges = this.visitPlanLineRangeRepository.findByVisitPlanCodes(visitPlanCodes);
        if (CollectionUtils.isEmpty(visitPlanLineRanges)) {
            return null;
        }
        List<String> rangeIds = visitPlanLineRanges.stream().map(UuidEntity::getId).collect(Collectors.toList());
        List<VisitPlanLineRangeMapping> visitPlanLineRangeMappings = this.visitPlanLineRangeMappingRepository.findByRangeIds(rangeIds);
        Map<Object, Object> map = new HashMap();
        if (!CollectionUtils.isEmpty(visitPlanLineRangeMappings)) {
            map = visitPlanLineRangeMappings.stream().collect(Collectors.groupingBy(VisitPlanLineRangeMapping::getRangeId));
        }
        HashMap<String, List<VisitPlanLineRangeMapping>> voMap = new HashMap<String, List<VisitPlanLineRangeMapping>>();
        for (VisitPlanLineRange visitPlanLineRange : visitPlanLineRanges) {
            String id = visitPlanLineRange.getId();
            List mappings = (List)map.get(id);
            if (CollectionUtils.isEmpty((Collection)mappings)) continue;
            voMap.put(visitPlanLineRange.getVisitPlanCode(), mappings);
        }
        return voMap;
    }

    private void createValidate(VisitPlanLineRangeMapping visitPlanLineRangeMapping) {
        Validate.notNull((Object)((Object)visitPlanLineRangeMapping), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        visitPlanLineRangeMapping.setId(null);
        Validate.notBlank((CharSequence)visitPlanLineRangeMapping.getLineCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ebf\u8def\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanLineRangeMapping.getLineName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ebf\u8def\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanLineRangeMapping.getRangeId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ebf\u8def\u7ec4\u62dc\u8bbf\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

