/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.line.local.service.internal;

import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineRangeMappingVo;
import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineRouteRangeVo;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineClientInfo;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRange;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRangeMapping;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineClientInfoRepository;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineRangeRepository;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineRangeMappingService;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineRangeService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="visitPlanLineRangeService")
public class VisitPlanLineRangeServiceImpl
implements VisitPlanLineRangeService {
    @Autowired
    private VisitPlanLineRangeRepository visitPlanLineRangeRepository;
    @Autowired
    private VisitPlanLineRangeMappingService visitPlanLineRangeMappingService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private VisitPlanLineClientInfoRepository visitPlanLineClientInfoRepository;

    @Override
    @Transactional
    public VisitPlanLineRange create(VisitPlanLineRange visitPlanLineRange) {
        this.createValidate(visitPlanLineRange);
        this.visitPlanLineRangeRepository.saveOrUpdate((Object)visitPlanLineRange);
        Set<VisitPlanLineRangeMapping> visitPlanLineRangeMappings = visitPlanLineRange.getVisitPlanLineRangeMappings();
        visitPlanLineRangeMappings.stream().forEach(visitPlanLineRangeMapping -> visitPlanLineRangeMapping.setRangeId(visitPlanLineRange.getId()));
        this.visitPlanLineRangeMappingService.createBatch(visitPlanLineRangeMappings);
        return visitPlanLineRange;
    }

    @Override
    @Transactional
    public VisitPlanLineRange update(VisitPlanLineRange visitPlanLineRange) {
        VisitPlanLineRange planLineRange = this.visitPlanLineRangeRepository.findByVisitPlanCode(visitPlanLineRange.getVisitPlanCode());
        if (planLineRange != null) {
            try {
                String nowDateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
                Date nowDate = DateUtils.parseDate((String)nowDateStr, (String[])new String[]{"yyyy-MM-dd"});
                Validate.isTrue((boolean)visitPlanLineRange.getLoopsEndDate().after(nowDate), (String)"\u4fee\u6539\u65f6\uff0c\u5faa\u73af\u7ed3\u675f\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\u4e0d\u5141\u8bb8\u4fee\u6539\uff01", (Object[])new Object[0]);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.visitPlanLineRangeMappingService.deleteByRangeId(planLineRange.getId());
            this.visitPlanLineRangeRepository.deleteByVisitPlanCode(visitPlanLineRange.getVisitPlanCode());
        }
        this.create(visitPlanLineRange);
        return visitPlanLineRange;
    }

    @Override
    public VisitPlanLineRouteRangeVo findByVisitPlanCode(String visitPlanCode) {
        if (StringUtils.isBlank((CharSequence)visitPlanCode)) {
            return null;
        }
        VisitPlanLineRange byVisitPlanCode = this.visitPlanLineRangeRepository.findByVisitPlanCode(visitPlanCode);
        if (byVisitPlanCode == null) {
            return null;
        }
        VisitPlanLineRouteRangeVo visitPlanLineRouteRangeVo = (VisitPlanLineRouteRangeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)byVisitPlanCode, VisitPlanLineRouteRangeVo.class, HashSet.class, ArrayList.class, new String[0]);
        Set<VisitPlanLineRangeMapping> visitPlanLineRangeMappingSet = this.visitPlanLineRangeMappingService.findByRangeId(byVisitPlanCode.getId());
        if (!CollectionUtils.isEmpty(visitPlanLineRangeMappingSet)) {
            Set visitPlanLineRangeMappingVos = (Set)this.nebulaToolkitService.copyCollectionByWhiteList(visitPlanLineRangeMappingSet, VisitPlanLineRangeMapping.class, VisitPlanLineRangeMappingVo.class, HashSet.class, ArrayList.class, new String[0]);
            Set<String> lineCodes = visitPlanLineRangeMappingVos.stream().map(VisitPlanLineRangeMappingVo::getLineCode).collect(Collectors.toSet());
            List<VisitPlanLineClientInfo> clientInfos = this.visitPlanLineClientInfoRepository.findByLineCodes(lineCodes);
            Map<Object, Object> clientCountMap = new HashMap();
            if (!CollectionUtils.isEmpty(clientInfos)) {
                clientCountMap = clientInfos.stream().collect(Collectors.groupingBy(VisitPlanLineClientInfo::getLineCode, Collectors.counting()));
            }
            for (VisitPlanLineRangeMappingVo o : visitPlanLineRangeMappingVos) {
                o.setClientCount((Long)clientCountMap.get(o.getLineCode()));
            }
            visitPlanLineRouteRangeVo.setVisitPlanLineRangeMappings(visitPlanLineRangeMappingVos);
        }
        return visitPlanLineRouteRangeVo;
    }

    @Override
    public List<VisitPlanLineRange> findByVisitPlanCodes(List<String> visitPlanCodes) {
        if (CollectionUtils.isEmpty(visitPlanCodes)) {
            return new ArrayList<VisitPlanLineRange>(0);
        }
        return this.visitPlanLineRangeRepository.findByVisitPlanCodes(visitPlanCodes);
    }

    private void createValidate(VisitPlanLineRange visitPlanLineRange) {
        Validate.notNull((Object)((Object)visitPlanLineRange), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        visitPlanLineRange.setId(null);
        Validate.notNull((Object)visitPlanLineRange.getLoopsEndDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5faa\u73af\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)visitPlanLineRange.getLoopsStartDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanLineRange.getVisitPlanCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u8ba1\u5212\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(visitPlanLineRange.getVisitPlanLineRangeMappings()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5173\u8054\u7ebf\u8def\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            String nowDateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
            Date nowDate = DateUtils.parseDate((String)nowDateStr, (String[])new String[]{"yyyy-MM-dd"});
            Validate.isTrue((visitPlanLineRange.getLoopsStartDate().compareTo(nowDate) >= 0 ? 1 : 0) != 0, (String)"\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u6216\u8005\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\uff01", (Object[])new Object[0]);
            Validate.isTrue((visitPlanLineRange.getLoopsEndDate().compareTo(visitPlanLineRange.getLoopsStartDate()) >= 0 ? 1 : 0) != 0, (String)"\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u6216\u8005\u7b49\u4e8e\u5faa\u73af\u7ed3\u675f\u65e5\u671f\uff01", (Object[])new Object[0]);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

