/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.line.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.sfa.visit.plan.line.sdk.dto.VisitPlanLineQueryDto;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLine;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineClientInfo;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineRangeMapping;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineRangeMappingRepository;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineRepository;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineClientInfoService;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="visitPlanLineService")
public class VisitPlanLineServiceImpl
implements VisitPlanLineService {
    @Autowired
    private VisitPlanLineRepository visitPlanLineRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private VisitPlanLineClientInfoService visitPlanLineClientInfoService;
    @Autowired
    private VisitPlanLineRangeMappingRepository visitPlanLineRangeMappingRepository;

    @Override
    public Page<VisitPlanLine> findByConditions(Pageable pageable, VisitPlanLineQueryDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new VisitPlanLineQueryDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.visitPlanLineRepository.findByConditions(pageable, dto);
    }

    @Override
    @Transactional
    public VisitPlanLine create(VisitPlanLine visitPlanLine) {
        this.createValidate(visitPlanLine);
        this.visitPlanLineRepository.saveOrUpdate((Object)visitPlanLine);
        List<VisitPlanLineClientInfo> visitPlanLineClientInfos = visitPlanLine.getVisitPlanLineClientInfos();
        visitPlanLineClientInfos.stream().forEach(visitPlanLineClientInfo -> visitPlanLineClientInfo.setLineCode(visitPlanLine.getLineCode()));
        this.visitPlanLineClientInfoService.createBatch(visitPlanLineClientInfos);
        return visitPlanLine;
    }

    @Override
    @Transactional
    public VisitPlanLine update(VisitPlanLine visitPlanLine) {
        Validate.notBlank((CharSequence)visitPlanLine.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        VisitPlanLine planLine = (VisitPlanLine)((Object)this.visitPlanLineRepository.getById((Serializable)((Object)visitPlanLine.getId())));
        Validate.notNull((Object)((Object)planLine), (String)"\u4fee\u6539\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u7ebf\u8def\u7ec4\u4fe1\u606f\uff01", (Object[])new Object[0]);
        BeanUtils.copyProperties((Object)((Object)visitPlanLine), (Object)((Object)planLine), (String[])new String[]{"id", "lineCode", "tenantCode", "delFlag", "enableStatus", "createAccount", "createTime", "createName"});
        this.updateValidate(planLine);
        this.visitPlanLineRepository.saveOrUpdate((Object)visitPlanLine);
        this.visitPlanLineClientInfoService.deleteByLineCode(planLine.getLineCode());
        List<VisitPlanLineClientInfo> visitPlanLineClientInfos = visitPlanLine.getVisitPlanLineClientInfos();
        visitPlanLineClientInfos.stream().forEach(visitPlanLineClientInfo -> visitPlanLineClientInfo.setLineCode(planLine.getLineCode()));
        this.visitPlanLineClientInfoService.createBatch(visitPlanLineClientInfos);
        return visitPlanLine;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<VisitPlanLine> visitPlanLines = this.visitPlanLineRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(visitPlanLines) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        List<String> lineCodes = visitPlanLines.stream().map(VisitPlanLine::getLineCode).collect(Collectors.toList());
        List<VisitPlanLineRangeMapping> rangeMappingList = this.visitPlanLineRangeMappingRepository.findByLineCodes(lineCodes);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(rangeMappingList), (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u8be5\u7ebf\u8def\u7ec4\u5728\u62dc\u8bbf\u8ba1\u5212\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01", (Object[])new Object[0]);
        this.visitPlanLineRepository.updateDelFlagByIds(idList, DelFlagStatusEnum.DELETE);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.visitPlanLineRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<VisitPlanLine> visitPlanLines = this.visitPlanLineRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(visitPlanLines) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u7981\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        List<String> lineCodes = visitPlanLines.stream().map(VisitPlanLine::getLineCode).collect(Collectors.toList());
        List<VisitPlanLineRangeMapping> rangeMappingList = this.visitPlanLineRangeMappingRepository.findByLineCodes(lineCodes);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(rangeMappingList), (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u8be5\u7ebf\u8def\u7ec4\u5728\u62dc\u8bbf\u8ba1\u5212\u4e2d\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\uff01", (Object[])new Object[0]);
        this.visitPlanLineRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    private void createValidate(VisitPlanLine visitPlanLine) {
        Validate.notNull((Object)((Object)visitPlanLine), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        visitPlanLine.setId(null);
        visitPlanLine.setTenantCode(TenantUtils.getTenantCode());
        visitPlanLine.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        visitPlanLine.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        visitPlanLine.setLineCode((String)this.generateCodeService.generateCode("XLZ", 1).get(0));
        Validate.notBlank((CharSequence)visitPlanLine.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanLine.getLineCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ebf\u8def\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanLine.getLineName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ebf\u8def\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanLine.getUserName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4eba\u5458\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanLine.getFullName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4eba\u5458\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(visitPlanLine.getVisitPlanLineClientInfos()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<VisitPlanLine> visitPlanLines = this.visitPlanLineRepository.findByUserNameAndLineName(visitPlanLine.getUserName(), visitPlanLine.getLineName());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(visitPlanLines), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f53\u524d\u4eba\u5458\u5b58\u5728\u76f8\u540c\u7684\u7ebf\u8def\u7ec4\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(VisitPlanLine visitPlanLine) {
        Validate.notNull((Object)((Object)visitPlanLine), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanLine.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanLine.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanLine.getLineCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7ebf\u8def\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanLine.getLineName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7ebf\u8def\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanLine.getUserName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4eba\u5458\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanLine.getFullName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4eba\u5458\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(visitPlanLine.getVisitPlanLineClientInfos()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<VisitPlanLine> visitPlanLines = this.visitPlanLineRepository.findByUserNameAndLineName(visitPlanLine.getUserName(), visitPlanLine.getLineName());
        if (!CollectionUtils.isEmpty(visitPlanLines)) {
            visitPlanLines.forEach(visitPlanLine1 -> Validate.isTrue((boolean)visitPlanLine1.getId().equals(visitPlanLine.getId()), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5f53\u524d\u4eba\u5458\u5b58\u5728\u76f8\u540c\u7684\u7ebf\u8def\u7ec4\uff01", (Object[])new Object[0]));
        }
    }
}

