/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.line.local.service.internal;

import cn.hutool.core.bean.BeanUtil;
import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineClientInfoVo;
import com.biz.crm.business.sfa.visit.plan.line.sdk.vo.VisitPlanLineVo;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLine;
import com.biz.crm.sfa.business.visit.plan.line.local.entity.VisitPlanLineClientInfo;
import com.biz.crm.sfa.business.visit.plan.line.local.repository.VisitPlanLineRepository;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineClientInfoService;
import com.biz.crm.sfa.business.visit.plan.line.local.service.VisitPlanLineVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="visitPlanLineVoService")
public class VisitPlanLineVoServiceImpl
implements VisitPlanLineVoService {
    @Autowired
    private VisitPlanLineRepository visitPlanLineRepository;
    @Autowired
    private VisitPlanLineClientInfoService visitPlanLineClientInfoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private List<ClientRouteStrategy> visitPlanClientRouteStrategies;

    @Override
    public VisitPlanLineVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        VisitPlanLine visitPlanLine = (VisitPlanLine)((Object)this.visitPlanLineRepository.getById((Serializable)((Object)id)));
        if (visitPlanLine == null) {
            return null;
        }
        VisitPlanLineVo visitPlanLineVo = (VisitPlanLineVo)this.nebulaToolkitService.copyObjectByBlankList((Object)visitPlanLine, VisitPlanLineVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<VisitPlanLineClientInfo> visitPlanLineClientInfos = this.visitPlanLineClientInfoService.findByLineCode(visitPlanLine.getLineCode());
        List<VisitPlanLineClientInfoVo> visitPlanLineClientInfoVos = this.buildVisitPlanLineClientInfo(visitPlanLineClientInfos);
        visitPlanLineVo.setVisitPlanLineClientInfoVos(visitPlanLineClientInfoVos);
        return visitPlanLineVo;
    }

    private List<VisitPlanLineClientInfoVo> buildVisitPlanLineClientInfo(List<VisitPlanLineClientInfo> visitPlanLineClientInfos) {
        if (CollectionUtils.isEmpty(visitPlanLineClientInfos)) {
            return new ArrayList<VisitPlanLineClientInfoVo>(0);
        }
        Map clientMap = visitPlanLineClientInfos.stream().collect(Collectors.groupingBy(VisitPlanLineClientInfo::getClientRoute, Collectors.groupingBy(VisitPlanLineClientInfo::getClientType, Collectors.mapping(VisitPlanLineClientInfo::getClientCode, Collectors.toList()))));
        Map<Object, Object> infoVoHashMap = new HashMap();
        if (!CollectionUtils.isEmpty(this.visitPlanClientRouteStrategies)) {
            ArrayList infoVos = new ArrayList();
            for (ClientRouteStrategy clientRouteStrategy : this.visitPlanClientRouteStrategies) {
                Map listMap = clientMap.get(clientRouteStrategy.getKey());
                if (listMap == null) continue;
                List terminalVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.TERMINAL.getDictCode()), ClientTypeEnum.TERMINAL.getDictCode());
                List dealerVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.DEALER.getDictCode()), ClientTypeEnum.DEALER.getDictCode());
                infoVos.addAll(terminalVos);
                infoVos.addAll(dealerVos);
            }
            if (!CollectionUtils.isEmpty(infoVos)) {
                infoVoHashMap = infoVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith((String)"_", (Object[])new Object[]{o.getClientRoute(), o.getClientType(), o.getClientCode()})));
            }
        }
        ArrayList<VisitPlanLineClientInfoVo> visitPlanLineClientInfoVos = new ArrayList<VisitPlanLineClientInfoVo>();
        for (VisitPlanLineClientInfo visitPlanLineClientInfo : visitPlanLineClientInfos) {
            VisitPlanLineClientInfoVo visitPlanLineClientInfoVo = (VisitPlanLineClientInfoVo)this.nebulaToolkitService.copyObjectByBlankList((Object)visitPlanLineClientInfo, VisitPlanLineClientInfoVo.class, HashSet.class, ArrayList.class, new String[0]);
            visitPlanLineClientInfoVos.add(visitPlanLineClientInfoVo);
            String key = StringUtils.joinWith((String)"_", (Object[])new Object[]{visitPlanLineClientInfo.getClientRoute(), visitPlanLineClientInfo.getClientType(), visitPlanLineClientInfo.getClientCode()});
            List infoVos = (List)infoVoHashMap.get(key);
            if (CollectionUtils.isEmpty((Collection)infoVos)) continue;
            ClientRouteInfoVo vo = (ClientRouteInfoVo)infoVos.get(0);
            BeanUtil.copyProperties((Object)vo, (Object)visitPlanLineClientInfoVo, (String[])new String[0]);
            visitPlanLineClientInfoVo.setAddress(vo.getClientAddress());
        }
        return visitPlanLineClientInfoVos;
    }
}

