package com.biz.crm.business.sfa.visit.plan.line.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Entity;

/**
 * 拜访计划线路组维度范围客户信息Vo
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@ApiModel(value = "VisitPlanLineRangeClientInfoVo", description = "拜访计划线路组维度范围客户信息Vo")
public class VisitPlanLineRangeClientInfoVo {

  private static final long serialVersionUID = 8840715398460223044L;

  /**
   * 线路组拜访信息id
   */
  @ApiModelProperty("线路组拜访信息id")
  private String rangeId;

  /**
   * 线路组编码
   */
  @ApiModelProperty("线路组编码")
  private String lineCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户维度
   * {@link VisitPlanClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  private String clientRoute;

  /**
   * 排序
   */
  @ApiModelProperty("排序")
  private Integer clientOrder;

}
