package com.biz.crm.business.sfa.visit.plan.line.sdk.vo;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Entity;
import java.util.List;

/**
 * 拜访计划线路组vo
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@ApiModel(value = "VisitPlanLineVo", description = "拜访计划线路组vo")
public class VisitPlanLineVo extends TenantFlagOpEntity {

  private static final long serialVersionUID = -5691768167656635023L;
  /**
   * 线路组编码
   */
  @ApiModelProperty("线路组编码")
  private String lineCode;

  /**
   * 线路组名称
   */
  @ApiModelProperty("线路组名称")
  private String lineName;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  private String userName;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String fullName;

  /**
   * 职位编码
   */
  @ApiModelProperty("人员职位编码")
  private String postCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String postName;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 客户信息集合
   */
  @ApiModelProperty("客户信息集合")
  private List<VisitPlanLineClientInfoVo> visitPlanLineClientInfoVos;
}
