package com.biz.crm.business.sfa.visit.plan.line.sdk.vo;

import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Entity;
import java.math.BigDecimal;
import java.util.List;

/**
 * 拜访计划线路组客户信息Vo
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@ApiModel(value = "VisitPlanLineClientInfoVo", description = "拜访计划线路组客户信息Vo")
public class VisitPlanLineClientInfoVo {

  private static final long serialVersionUID = 8840715398460223044L;
  /**
   * 线路组编码
   */
  @ApiModelProperty("线路组编码")
  private String lineCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  private String clientRoute;

  /**
   * 客户细类名称
   */
  @ApiModelProperty("客户细类名称")
  private String clientSubName;

  /**
   * 联系人列表
   */
  @ApiModelProperty("联系人列表")
  private List<ClientContactVo> contactList;

  /**
   * 终端地址
   */
  @ApiModelProperty("终端地址")
  private String address;

  /**
   * 排序
   */
  @ApiModelProperty("排序")
  private Integer clientOrder;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;

}
