package com.biz.crm.sfa.business.visit.plan.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailException;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailExceptionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 拜访计划明细异常表(VisitPlanDetailException)表相关的http接口
 *
 * @author songjingen
 * @since 2022-06-28 19:12:17
 */
@RestController
@RequestMapping("/v1/visitPlan/visitPlanDetailException")
@Slf4j
@Api(tags = "拜访计划:VisitPlanDetailException:拜访计划明细异常表")
public class VisitPlanDetailExceptionController {
  /**
   * 服务对象
   */
  @Autowired
  private VisitPlanDetailExceptionService visitPlanDetailExceptionService;

  /**
   * 通过计划明细主键查询单条数据
   *
   * @param visitPlanDetailId 计划明细主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("findByVisitPlanDetailId")
  public Result<VisitPlanDetailException> findByVisitPlanDetailId(@ApiParam(name = "visitPlanDetailId", value = "计划明细主键") @RequestParam("visitPlanDetailId") String visitPlanDetailId) {
    try {
      VisitPlanDetailException visitPlanDetailException = this.visitPlanDetailExceptionService.findByVisitPlanDetailId(visitPlanDetailId);
      return Result.ok(visitPlanDetailException);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param visitPlanDetailException 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<VisitPlanDetailException> create(@ApiParam(name = "visitPlanDetailException", value = "拜访计划明细异常表") @RequestBody VisitPlanDetailException visitPlanDetailException) {
    try {
      VisitPlanDetailException result = this.visitPlanDetailExceptionService.create(visitPlanDetailException);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
