package com.biz.crm.sfa.business.visit.plan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlan;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailExceptionVoService;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailExceptionQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailExceptionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 拜访计划异常提报表
 * @author: rentao
 * @date: 2022/7/5 19:44
 */
@RestController
@RequestMapping("/v1/visitPlan/visitPlanDetailException")
@Slf4j
@Api(tags = "拜访计划异常提报：VisitPlanDetailExceptionVo：拜访计划异常提报表")
public class VisitPlanDetailExceptionVoController {

  @Autowired private VisitPlanDetailExceptionVoService visitPlanDetailExceptionVoService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param visitPlanQueryDto 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "后台-异常提报报表")
  @GetMapping("findByConditions")
  public Result<Page<VisitPlanDetailExceptionVo>> findByConditions(
      @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "visitPlanDetailExceptionQueryDto", value = "异常提报报表查询dto")
          VisitPlanDetailExceptionQueryDto visitPlanQueryDto) {
    try {
      Page<VisitPlanDetailExceptionVo> page =
          this.visitPlanDetailExceptionVoService.findByConditions(pageable, visitPlanQueryDto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<VisitPlanDetailExceptionVo> findById(
      @PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      VisitPlanDetailExceptionVo visitPlanDetailExceptionVo = this.visitPlanDetailExceptionVoService.findById(id);
      return Result.ok(visitPlanDetailExceptionVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
