package com.biz.crm.sfa.business.visit.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.sfa.business.visit.plan.sdk.abstracts.VisitPlanRouteRangeAbstract;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitPlanTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.register.VisitPlanRouteRegister;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

/**
 * 拜访计划制定 实体类
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_visit_plan")
@Table(name = "sfa_visit_plan", indexes = {
    @Index(name = "sfa_visit_plan_index1", columnList = "tenant_code,visit_plan_code", unique = true),
})
@ApiModel(value = "VisitPlan", description = "拜访计划制定表")
@org.hibernate.annotations.Table(appliesTo = "sfa_visit_plan", comment = "拜访计划制定表")
public class VisitPlan extends TenantFlagOpEntity {

  private static final long serialVersionUID = 7022214277071025864L;
  /**
   * 拜访计划编码
   */
  @ApiModelProperty("拜访计划编码")
  @Column(name = "visit_plan_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '拜访计划编码'")
  private String visitPlanCode;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  @Column(name = "visit_user_name", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '人员账号'")
  private String visitUserName;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  @Column(name = "visit_real_name", length = 255, columnDefinition = "varchar(255) COMMENT '人员姓名'")
  private String visitRealName;

  /**
   * 人员职位编码
   */
  @ApiModelProperty("人员职位编码")
  @Column(name = "visit_post_code", length = 64, columnDefinition = "varchar(64) COMMENT '人员职位编码'")
  private String visitPostCode;

  /**
   * 人员职位名称
   */
  @ApiModelProperty("人员职位名称")
  @Column(name = "visit_post_name", length = 255, columnDefinition = "varchar(255) COMMENT '人员职位名称'")
  private String visitPostName;

  /**
   * 人员所属组织编码
   */
  @ApiModelProperty("人员所属组织编码")
  @Column(name = "visit_org_code", length = 64, columnDefinition = "varchar(64) COMMENT '人员所属组织编码'")
  private String visitOrgCode;

  /**
   * 人员所属组织名称
   */
  @ApiModelProperty("人员所属组织名称")
  @Column(name = "visit_org_name", length = 255, columnDefinition = "varchar(255) COMMENT '人员所属组织名称'")
  private String visitOrgName;

  /**
   * 拜访类型  临时拜访-计划外，计划拜访-计划内
   * <p>
   * {@link VisitPlanTypeEnum#getDictCode()}
   */
  @ApiModelProperty("拜访计划类型")
  @Column(name = "visit_plan_type", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '拜访类型'")
  private String visitPlanType;

  /**
   * 维度类型 维度类型（线路组、网点、频率）
   * <p>
   * {@link VisitPlanRouteRegister#getKey()}
   */
  @ApiModelProperty("拜访维度类型")
  @Column(name = "visit_route_type", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '拜访维度类型'")
  private String visitRouteType;

  /**
   * 拜访开始时间
   */
  @ApiModelProperty("拜访开始时间")
  @Column(name = "start_date", length = 20, columnDefinition = "date COMMENT '拜访开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date startDate;

  /**
   * 拜访结束时间
   */
  @ApiModelProperty("拜访结束时间")
  @Column(name = "end_date", length = 20, columnDefinition = "date COMMENT '拜访结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date endDate;

  @Transient
  @TableField(exist = false)
  @ApiModelProperty("拜访维度拜访信息策略对象")
  private VisitPlanRouteRangeAbstract visitPlanRouteRangeAbstract;
}
