package com.biz.crm.sfa.business.visit.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.sfa.business.step.sdk.vo.StepFormLogoVo;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 拜访计划明细完成情况
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_visit_plan_detail_performance")
@Table(name = "sfa_visit_plan_detail_performance")
@ApiModel(value = "VisitPlanDetailPerformance", description = "拜访计划明细完成情况表")
@org.hibernate.annotations.Table(appliesTo = "sfa_visit_plan_detail_performance", comment = "拜访计划明细完成情况表")
public class VisitPlanDetailPerformance extends UuidOpEntity {

  private static final long serialVersionUID = 7022214277071025864L;
  /**
   * 拜访计划明细id
   */
  @ApiModelProperty("拜访计划明细id")
  @Column(name = "visit_plan_detail_id", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '拜访计划明细id'")
  private String visitPlanDetailId;

  /**
   * 步骤编码
   */
  @ApiModelProperty("步骤编码")
  @Column(name = "step_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '步骤编码'")
  private String stepCode;

  /**
   * 表单编码
   */
  @ApiModelProperty("表单编码")
  @Column(name = "form_code", columnDefinition = "varchar(255) COMMENT '表单编码'")
  private String formCode;

  /**
   * 步骤名称
   */
  @ApiModelProperty("步骤名称")
  @Transient
  @TableField(exist = false)
  private String stepName;

  @Transient
  @TableField(exist = false)
  @ApiModelProperty("步骤数据")
  private AbstractDynamicTemplateModel abstractDynamicTemplateModel;

  /**
   * logo集合
   */
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("logo集合")
  private List<StepFormLogoVo> logos;
}
