package com.biz.crm.sfa.business.visit.plan.local.mapper;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetail;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailVo;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 拜访计划明细表(VisitPlanDetailVo)表mybatis访问层
 *
 * @author songjingen
 * @since 2022-05-13 13:59:26
 */
public interface VisitPlanDetailVoMapper {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param dto  查询实体
   * @return 所有数据
   */
  public Page<VisitPlanDetailVo> findByConditions(@Param("page") Page<VisitPlanDetail> page, @Param("dto") VisitPlanDetailQueryDto dto);

  /**
   * 按照条件查询数据（不带分页）
   *
   * @param dto 查询实体
   * @return 所有数据
   */
  public List<VisitPlanDetailVo> findByConditions(@Param("dto") VisitPlanDetailQueryDto dto);

  /**
   * 用户+拜访时间+客户编码+拜访状态查询数据
   *
   * @param userNameSets
   * @param clientCodeSets
   * @param visitDateSets
   * @param visitStatusSets
   * @return
   */
  List<VisitPlanDetailVo> findByUserNamesAndClientCodesAndVisitDatesAndVisitStatus(@Param("userNameSets") Set<String> userNameSets, @Param("clientCodeSets") Set<String> clientCodeSets, @Param("visitDateSets") Set<Date> visitDateSets, @Param("visitStatusSets") Set<String> visitStatusSets);
}

