package com.biz.crm.sfa.business.visit.plan.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailException;
import com.biz.crm.sfa.business.visit.plan.local.mapper.VisitPlanDetailExceptionMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 拜访计划明细异常表(VisitPlanDetailException)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-28 19:12:17
 */
@Component
public class VisitPlanDetailExceptionRepository extends ServiceImpl<VisitPlanDetailExceptionMapper, VisitPlanDetailException> {

  /**
   * 根据明细主键查询数据
   *
   * @param visitPlanDetailId
   * @return
   */
  public List<VisitPlanDetailException> findByVisitPlanDetailId(String visitPlanDetailId) {
    return this.lambdaQuery().eq(VisitPlanDetailException::getVisitPlanDetailId, visitPlanDetailId).list();
  }
}

