package com.biz.crm.sfa.business.visit.plan.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlan;
import com.biz.crm.sfa.business.visit.plan.local.mapper.VisitPlanDetailExceptionVoMapper;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailExceptionQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailExceptionVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @description: 异常提报vo
 * @author: rentao
 * @date: 2022/7/6 10:22
 */
@Component
public class VisitPlanDetailExceptionVoRepository {

  @Autowired private VisitPlanDetailExceptionVoMapper visitPlanDetailExceptionVoMapper;

  /**
   * 分页查询数据
   *
   * @param pageable          分页对象
   * @param visitPlanDetailExceptionQueryDto 查询对象
   * @return
   */
  public Page<VisitPlanDetailExceptionVo> findByConditions(Pageable pageable, VisitPlanDetailExceptionQueryDto visitPlanDetailExceptionQueryDto) {
    Page<VisitPlanDetailExceptionVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<VisitPlanDetailExceptionVo> pageList = this.visitPlanDetailExceptionVoMapper.findByConditions(page, visitPlanDetailExceptionQueryDto);
    return pageList;
  }

  /**
   * id查询
   *
   * @param id          主键
   * @return
   */
  public VisitPlanDetailExceptionVo findById(String id) {
    return this.visitPlanDetailExceptionVoMapper.findById(id);
  }
}
