package com.biz.crm.sfa.business.visit.plan.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailPerformance;
import com.biz.crm.sfa.business.visit.plan.local.mapper.VisitPlanDetailPerformanceMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 拜访计划明细完成情况表(VisitPlanDetailPerformance)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-21 16:42:20
 */
@Component
public class VisitPlanDetailPerformanceRepository extends ServiceImpl<VisitPlanDetailPerformanceMapper, VisitPlanDetailPerformance> {

  /**
   * 根据明细id查询数据
   *
   * @param id
   * @return
   */
  public List<VisitPlanDetailPerformance> findByDetailId(String id) {
    return this.lambdaQuery().eq(VisitPlanDetailPerformance::getVisitPlanDetailId, id)
        .orderByAsc(VisitPlanDetailPerformance::getCreateTime)
        .list();
  }
}

