package com.biz.crm.sfa.business.visit.plan.local.service;


import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetail;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 拜访计划明细表(VisitPlanDetail)表服务接口
 *
 * @author songjingen
 * @since 2022-05-13 13:59:26
 */
public interface VisitPlanDetailService {

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 根据拜访计划编码和状态删除数据
   *
   * @param visitPlanCodes
   * @param visitStatus
   */
  void deleteByVisitPlanCodesAndVisitStatus(Set<String> visitPlanCodes, String visitStatus);

  /**
   * 查看完成进度
   *
   * @param userName
   * @param visitDate
   * @return {"completed":"已完成数量","total":"总数量"}
   */
  Map<String, Integer> findScheduleByUserNameAndVisitDate(String userName, Date visitDate);

  /**
   * 根据用户账号和拜访日期查询数据
   *
   * @param visitDate 拜访日期
   * @param userName  用户账号
   * @return
   */
  List<VisitPlanDetail> findByVisitDateAndUserName(Date visitDate, String userName);

  /**
   * 根据拜访计划编码删除数据
   *
   * @param visitPlanCodes
   */
  void deleteByVisitPlanCodes(Set<String> visitPlanCodes);

  /**
   * 执行任务，每天零时5分结束前一天的拜访中任务
   */
  void executeTask();

  /**
   * 根据客户编码和客户类型查询数据
   *
   * @param clientCodes
   * @param clientType
   * @param visitStatus
   * @return
   */
  List<VisitPlanDetail> findByClientCodesAndClientTypeAndVisitStatus(Set<String> clientCodes, String clientType, String visitStatus);

  /**
   * 根据id查询详情
   *
   * @param id
   * @return
   */
  VisitPlanDetail findById(String id);
}

