package com.biz.crm.sfa.business.visit.plan.local.service;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlan;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanQueryDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 拜访计划制定表(VisitPlan)表服务接口
 *
 * @author songjingen
 * @since 2022-05-06 11:15:39
 */
public interface VisitPlanService {

  /**
   * 分页查询数据
   *
   * @param pageable          分页对象
   * @param visitPlanQueryDto 查询对象
   * @return
   */
  Page<VisitPlan> findByConditions(Pageable pageable, VisitPlanQueryDto visitPlanQueryDto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  VisitPlan findById(String id);

  /**
   * 新增数据
   *
   * @param jsonObject 实体对象
   * @return 新增结果
   */
  VisitPlan create(JSONObject jsonObject);

  /**
   * 修改新据
   *
   * @param jsonObject 实体对象
   * @return 修改结果
   */
  VisitPlan update(JSONObject jsonObject);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);

  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);

}

